/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.HermiT.blocking.DirectBlockingChecker;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ValidatedBlockersCache {
    protected Tableau m_tableau;
    protected final DirectBlockingChecker m_directBlockingChecker;
    protected CacheEntry[] m_buckets;
    protected int m_numberOfElements;
    protected int m_threshold;
    protected CacheEntry m_emptyEntries;

    public ValidatedBlockersCache(DirectBlockingChecker directBlockingChecker) {
        this.m_directBlockingChecker = directBlockingChecker;
        this.clear();
    }

    public boolean isEmpty() {
        return this.m_numberOfElements == 0;
    }

    public void clear() {
        this.m_buckets = new CacheEntry[1024];
        this.m_threshold = (int)((double)this.m_buckets.length * 0.75);
        this.m_numberOfElements = 0;
        this.m_emptyEntries = null;
    }

    public boolean removeNode(Node node) {
        CacheEntry cacheEntry = (CacheEntry)node.getBlockingCargo();
        if (cacheEntry != null) {
            int n = ValidatedBlockersCache.getIndexFor(cacheEntry.m_hashCode, this.m_buckets.length);
            CacheEntry cacheEntry2 = null;
            CacheEntry cacheEntry3 = this.m_buckets[n];
            while (cacheEntry3 != null) {
                if (cacheEntry3 == cacheEntry) {
                    if (node == cacheEntry3.m_nodes.get(0)) {
                        for (Node node2 : cacheEntry3.m_nodes) {
                            node2.setBlockingCargo(null);
                        }
                        if (cacheEntry2 == null) {
                            this.m_buckets[n] = cacheEntry3.m_nextEntry;
                        } else {
                            cacheEntry2.m_nextEntry = cacheEntry3.m_nextEntry;
                        }
                        cacheEntry3.m_nextEntry = this.m_emptyEntries;
                        cacheEntry3.m_nodes = new ArrayList<Node>();
                        cacheEntry3.m_hashCode = 0;
                        this.m_emptyEntries = cacheEntry3;
                        --this.m_numberOfElements;
                    } else if (cacheEntry3.m_nodes.contains(node)) {
                        for (int i = cacheEntry3.m_nodes.size() - 1; i >= cacheEntry3.m_nodes.indexOf(node); --i) {
                            cacheEntry3.m_nodes.get(i).setBlockingCargo(null);
                        }
                        cacheEntry3.m_nodes.subList(cacheEntry3.m_nodes.indexOf(node), cacheEntry3.m_nodes.size()).clear();
                    } else {
                        throw new IllegalStateException("Internal error: entry not in cache!");
                    }
                    return true;
                }
                cacheEntry2 = cacheEntry3;
                cacheEntry3 = cacheEntry3.m_nextEntry;
            }
            throw new IllegalStateException("Internal error: entry not in cache!");
        }
        return false;
    }

    public void addNode(Node node) {
        int n = this.m_directBlockingChecker.blockingHashCode(node);
        int n2 = ValidatedBlockersCache.getIndexFor(n, this.m_buckets.length);
        CacheEntry cacheEntry = this.m_buckets[n2];
        while (cacheEntry != null) {
            if (n == cacheEntry.m_hashCode && this.m_directBlockingChecker.isBlockedBy(cacheEntry.m_nodes.get(0), node)) {
                if (!cacheEntry.m_nodes.contains(node)) {
                    cacheEntry.add(node);
                    node.setBlockingCargo(cacheEntry);
                    return;
                }
                throw new IllegalStateException("Internal error: node already in the cache!");
            }
            cacheEntry = cacheEntry.m_nextEntry;
        }
        if (this.m_emptyEntries == null) {
            cacheEntry = new CacheEntry();
        } else {
            cacheEntry = this.m_emptyEntries;
            this.m_emptyEntries = this.m_emptyEntries.m_nextEntry;
        }
        cacheEntry.initialize(node, n, this.m_buckets[n2]);
        this.m_buckets[n2] = cacheEntry;
        node.setBlockingCargo(cacheEntry);
        ++this.m_numberOfElements;
        if (this.m_numberOfElements >= this.m_threshold) {
            this.resize(this.m_buckets.length * 2);
        }
    }

    protected void resize(int n) {
        CacheEntry[] cacheEntryArray = new CacheEntry[n];
        for (int i = 0; i < this.m_buckets.length; ++i) {
            CacheEntry cacheEntry = this.m_buckets[i];
            while (cacheEntry != null) {
                CacheEntry cacheEntry2 = cacheEntry.m_nextEntry;
                int n2 = ValidatedBlockersCache.getIndexFor(cacheEntry.m_hashCode, n);
                cacheEntry.m_nextEntry = cacheEntryArray[n2];
                cacheEntryArray[n2] = cacheEntry;
                cacheEntry = cacheEntry2;
            }
        }
        this.m_buckets = cacheEntryArray;
        this.m_threshold = (int)((double)n * 0.75);
    }

    public Node getBlocker(Node node) {
        if (this.m_directBlockingChecker.canBeBlocked(node)) {
            int n = this.m_directBlockingChecker.blockingHashCode(node);
            int n2 = ValidatedBlockersCache.getIndexFor(n, this.m_buckets.length);
            CacheEntry cacheEntry = this.m_buckets[n2];
            while (cacheEntry != null) {
                if (n == cacheEntry.m_hashCode && this.m_directBlockingChecker.isBlockedBy(cacheEntry.m_nodes.get(0), node)) {
                    if (node.getBlocker() != null && cacheEntry.m_nodes.contains(node.getBlocker())) {
                        return node.getBlocker();
                    }
                    return cacheEntry.m_nodes.get(0);
                }
                cacheEntry = cacheEntry.m_nextEntry;
            }
        }
        return null;
    }

    public List<Node> getPossibleBlockers(Node node) {
        if (this.m_directBlockingChecker.canBeBlocked(node)) {
            int n = this.m_directBlockingChecker.blockingHashCode(node);
            int n2 = ValidatedBlockersCache.getIndexFor(n, this.m_buckets.length);
            CacheEntry cacheEntry = this.m_buckets[n2];
            while (cacheEntry != null) {
                if (n == cacheEntry.m_hashCode && this.m_directBlockingChecker.isBlockedBy(cacheEntry.m_nodes.get(0), node)) {
                    assert (!cacheEntry.m_nodes.contains(node));
                    return cacheEntry.m_nodes;
                }
                cacheEntry = cacheEntry.m_nextEntry;
            }
        }
        return new ArrayList<Node>();
    }

    protected static int getIndexFor(int n, int n2) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n & n2 - 1;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.m_buckets.length; ++i) {
            CacheEntry cacheEntry = this.m_buckets[i];
            if (cacheEntry == null) continue;
            string = string + "Bucket " + i + ": [" + cacheEntry.toString() + "] ";
        }
        return string;
    }

    public static class CacheEntry
    implements Serializable {
        private static final long serialVersionUID = -7047487963170250200L;
        protected List<Node> m_nodes;
        protected int m_hashCode;
        protected CacheEntry m_nextEntry;

        public void initialize(Node node, int n, CacheEntry cacheEntry) {
            this.m_nodes = new ArrayList<Node>();
            this.add(node);
            this.m_hashCode = n;
            this.m_nextEntry = cacheEntry;
        }

        public boolean add(Node node) {
            for (Node node2 : this.m_nodes) {
                assert (node2.getNodeID() <= node.getNodeID());
            }
            return this.m_nodes.add(node);
        }

        public String toString() {
            String string = "HashCode: " + this.m_hashCode + " Nodes: ";
            for (Node node : this.m_nodes) {
                string = string + node.getNodeID() + " ";
            }
            return string;
        }
    }
}

