/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import java.util.List;
import org.semanticweb.HermiT.blocking.BlockingSignatureCache;
import org.semanticweb.HermiT.blocking.BlockingStrategy;
import org.semanticweb.HermiT.blocking.DirectBlockingChecker;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.tableau.DLClauseEvaluator;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AncestorBlocking
implements BlockingStrategy,
Serializable {
    private static final long serialVersionUID = 1075850000309773283L;
    protected final DirectBlockingChecker m_directBlockingChecker;
    protected final BlockingSignatureCache m_blockingSignatureCache;
    protected Tableau m_tableau;
    protected boolean m_useBlockingSignatureCache;

    public AncestorBlocking(DirectBlockingChecker directBlockingChecker, BlockingSignatureCache blockingSignatureCache) {
        this.m_directBlockingChecker = directBlockingChecker;
        this.m_blockingSignatureCache = blockingSignatureCache;
    }

    @Override
    public void initialize(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_directBlockingChecker.initialize(tableau);
        this.updateBlockingSignatureCacheUsage();
    }

    @Override
    public void additionalDLOntologySet(DLOntology dLOntology) {
        this.updateBlockingSignatureCacheUsage();
    }

    @Override
    public void additionalDLOntologyCleared() {
        this.updateBlockingSignatureCacheUsage();
    }

    protected void updateBlockingSignatureCacheUsage() {
        this.m_useBlockingSignatureCache = this.m_tableau.getAdditionalHyperresolutionManager() == null;
    }

    @Override
    public void clear() {
        this.m_directBlockingChecker.clear();
    }

    @Override
    public void computeBlocking(boolean bl) {
        for (Node node = this.m_tableau.getFirstTableauNode(); node != null; node = node.getNextTableauNode()) {
            if (!node.isActive()) continue;
            Node node2 = node.getParent();
            if (node2 == null) {
                node.setBlocked(null, false);
                continue;
            }
            if (node2.isBlocked()) {
                node.setBlocked(node2, false);
                continue;
            }
            if (this.m_useBlockingSignatureCache && this.m_blockingSignatureCache != null && this.m_blockingSignatureCache.containsSignature(node)) {
                node.setBlocked(Node.SIGNATURE_CACHE_BLOCKER, true);
                continue;
            }
            this.checkParentBlocking(node);
        }
    }

    public boolean computeIsBlocked(Node node) {
        throw new UnsupportedOperationException("Unsupported operation: Ancestor blocking cannot be used with a lazy expansion strategy. ");
    }

    protected final void checkParentBlocking(Node node) {
        for (Node node2 = node.getParent(); node2 != null; node2 = node2.getParent()) {
            if (!this.m_directBlockingChecker.isBlockedBy(node2, node)) continue;
            node.setBlocked(node2, true);
            break;
        }
    }

    @Override
    public boolean isPermanentAssertion(Concept concept, Node node) {
        return true;
    }

    @Override
    public boolean isPermanentAssertion(DataRange dataRange, Node node) {
        return true;
    }

    @Override
    public void assertionAdded(Concept concept, Node node, boolean bl) {
        this.m_directBlockingChecker.assertionAdded(concept, node, bl);
    }

    @Override
    public void assertionCoreSet(Concept concept, Node node) {
    }

    @Override
    public void assertionRemoved(Concept concept, Node node, boolean bl) {
        this.m_directBlockingChecker.assertionRemoved(concept, node, bl);
    }

    @Override
    public void assertionAdded(DataRange dataRange, Node node, boolean bl) {
        this.m_directBlockingChecker.assertionAdded(dataRange, node, bl);
    }

    @Override
    public void assertionCoreSet(DataRange dataRange, Node node) {
    }

    @Override
    public void assertionRemoved(DataRange dataRange, Node node, boolean bl) {
        this.m_directBlockingChecker.assertionRemoved(dataRange, node, bl);
    }

    @Override
    public void assertionAdded(AtomicRole atomicRole, Node node, Node node2, boolean bl) {
        this.m_directBlockingChecker.assertionAdded(atomicRole, node, node2, bl);
    }

    @Override
    public void assertionCoreSet(AtomicRole atomicRole, Node node, Node node2) {
        this.m_directBlockingChecker.assertionAdded(atomicRole, node, node2, true);
    }

    @Override
    public void assertionRemoved(AtomicRole atomicRole, Node node, Node node2, boolean bl) {
        this.m_directBlockingChecker.assertionRemoved(atomicRole, node, node2, bl);
    }

    @Override
    public void nodesMerged(Node node, Node node2) {
        this.m_directBlockingChecker.nodesMerged(node, node2);
    }

    @Override
    public void nodesUnmerged(Node node, Node node2) {
        this.m_directBlockingChecker.nodesUnmerged(node, node2);
    }

    @Override
    public void nodeStatusChanged(Node node) {
    }

    @Override
    public void nodeInitialized(Node node) {
        this.m_directBlockingChecker.nodeInitialized(node);
    }

    @Override
    public void nodeDestroyed(Node node) {
        this.m_directBlockingChecker.nodeDestroyed(node);
    }

    @Override
    public void modelFound() {
        if (this.m_useBlockingSignatureCache && this.m_blockingSignatureCache != null) {
            for (Node node = this.m_tableau.getFirstTableauNode(); node != null; node = node.getNextTableauNode()) {
                if (!node.isActive() || node.isBlocked() || !this.m_directBlockingChecker.canBeBlocker(node)) continue;
                this.m_blockingSignatureCache.addNode(node);
            }
        }
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public void dlClauseBodyCompiled(List<DLClauseEvaluator.Worker> list, DLClause dLClause, List<Variable> list2, Object[] objectArray, boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
    }
}

