/*
 * Decompiled with CFR 0.152.
 */
package rationals;

import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import rationals.Automaton;
import rationals.State;
import rationals.StateFactory;

public class DefaultStateFactory
implements StateFactory,
Cloneable {
    private int id = 0;
    private Automaton automaton;

    DefaultStateFactory(Automaton a) {
        this.automaton = a;
    }

    public State create(boolean initial, boolean terminal) {
        return new DefaultState(this.id++, initial, terminal);
    }

    public Set stateSet() {
        return new DefaultStateSet(this);
    }

    public Set stateSet(Set s) {
        return new DefaultStateSet((DefaultStateSet)s, this);
    }

    public Object clone() {
        DefaultStateFactory cl;
        try {
            cl = (DefaultStateFactory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            cl = null;
        }
        cl.id = 0;
        return cl;
    }

    public void setAutomaton(Automaton automaton) {
        this.automaton = automaton;
    }

    class DefaultStateSet
    implements Set {
        private DefaultStateFactory df;
        private int modcount = 0;
        private int mods = 0;
        private int bit = -1;
        private BitSet bits = new BitSet();
        private Iterator it = new Iterator(){

            public void remove() {
                if (DefaultStateSet.this.bit > 0) {
                    DefaultStateSet.this.bits.clear(DefaultStateSet.this.bit);
                }
            }

            public boolean hasNext() {
                return DefaultStateSet.this.bits.nextSetBit(DefaultStateSet.this.bit) > -1;
            }

            public Object next() {
                DefaultStateSet.this.bit = DefaultStateSet.this.bits.nextSetBit(DefaultStateSet.this.bit);
                if (DefaultStateSet.this.bit == -1) {
                    throw new NoSuchElementException();
                }
                DefaultState ds = new DefaultState(DefaultStateSet.this.bit, false, false);
                ds.initial = DefaultStateFactory.this.automaton.initials().contains(ds);
                ds.terminal = DefaultStateFactory.this.automaton.terminals().contains(ds);
                DefaultStateSet.this.mods++;
                DefaultStateSet.this.modcount++;
                if (DefaultStateSet.this.mods != DefaultStateSet.this.modcount) {
                    throw new ConcurrentModificationException();
                }
                DefaultStateSet.this.bit++;
                return ds;
            }
        };

        public DefaultStateSet(DefaultStateSet set, DefaultStateFactory df) {
            this.bits = (BitSet)set.bits.clone();
            this.df = df;
        }

        public DefaultStateSet(DefaultStateFactory df) {
            this.df = df;
        }

        public boolean equals(Object obj) {
            DefaultStateSet dss = (DefaultStateSet)obj;
            return dss == null ? false : dss.bits.equals(this.bits) && dss.df == this.df;
        }

        public int hashCode() {
            return this.bits.hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            String b = this.bits.toString();
            sb.append(b.substring(1, b.length() - 1));
            sb.append(']');
            return sb.toString();
        }

        public int size() {
            return this.bits.cardinality();
        }

        public void clear() {
            ++this.modcount;
            this.bits.clear();
        }

        public boolean isEmpty() {
            return this.bits.isEmpty();
        }

        public Object[] toArray() {
            Object[] ret = new Object[this.size()];
            Iterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                ret[i++] = it.next();
            }
            return ret;
        }

        public boolean add(Object o) {
            DefaultState ds = (DefaultState)o;
            if (this.bits.get(ds.i)) {
                return false;
            }
            this.bits.set(ds.i);
            ++this.modcount;
            return true;
        }

        public boolean contains(Object o) {
            DefaultState ds = (DefaultState)o;
            return this.bits.get(ds.i);
        }

        public boolean remove(Object o) {
            DefaultState ds = (DefaultState)o;
            if (!this.bits.get(ds.i)) {
                return false;
            }
            this.bits.clear(ds.i);
            ++this.modcount;
            return true;
        }

        public boolean addAll(Collection c) {
            DefaultStateSet dss = (DefaultStateSet)c;
            this.bits.or(dss.bits);
            ++this.modcount;
            return true;
        }

        public boolean containsAll(Collection c) {
            DefaultStateSet dss = (DefaultStateSet)c;
            BitSet bs = new BitSet();
            bs.or(this.bits);
            bs.and(dss.bits);
            ++this.modcount;
            return bs.equals(dss.bits);
        }

        public boolean removeAll(Collection c) {
            DefaultStateSet dss = (DefaultStateSet)c;
            this.bits.andNot(dss.bits);
            ++this.modcount;
            return true;
        }

        public boolean retainAll(Collection c) {
            DefaultStateSet dss = (DefaultStateSet)c;
            this.bits.and(dss.bits);
            ++this.modcount;
            return true;
        }

        public Iterator iterator() {
            this.mods = 0;
            this.modcount = 0;
            this.bit = 0;
            return this.it;
        }

        public Object[] toArray(Object[] a) {
            Object[] ret = a.length == this.size() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
            Iterator it = this.iterator();
            boolean i = false;
            while (it.hasNext()) {
                DefaultState ds = (DefaultState)it.next();
                ret[ds.i] = ds;
            }
            return ret;
        }
    }

    public class DefaultState
    implements State {
        public final int i;
        boolean initial;
        boolean terminal;
        Automaton a;

        DefaultState(int i, boolean initial, boolean terminal) {
            this.i = i;
            this.a = DefaultStateFactory.this.automaton;
            this.initial = initial;
            this.terminal = terminal;
        }

        public Object getObject() {
            return new Integer(this.i);
        }

        public void setObject(Object object) {
        }

        public void setInitial(boolean initial) {
            this.initial = initial;
        }

        public void setTerminal(boolean terminal) {
            this.terminal = terminal;
        }

        public boolean isInitial() {
            return this.initial;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public String toString() {
            return Integer.toString(this.i);
        }

        public boolean equals(Object o) {
            try {
                DefaultState ds = (DefaultState)o;
                return ds.i == this.i && this.a == ds.a;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.i;
        }
    }
}

