/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.DebuggerCommand;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.tableau.Node;

public abstract class AbstractCommand
implements DebuggerCommand {
    protected final Debugger m_debugger;

    public AbstractCommand(Debugger debugger) {
        this.m_debugger = debugger;
    }

    protected void showTextInWindow(String string, String string2) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setFont(Debugger.s_monospacedFont);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        JFrame jFrame = new JFrame(string2);
        jFrame.setDefaultCloseOperation(2);
        jFrame.setContentPane(jScrollPane);
        jFrame.pack();
        jFrame.setLocation(100, 100);
        jFrame.setVisible(true);
    }

    protected void selectConsoleWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (AbstractCommand.this.m_debugger != null) {
                    AbstractCommand.this.m_debugger.getMainFrame().toFront();
                }
            }
        });
    }

    protected DLPredicate getDLPredicate(String string) throws Exception {
        if ("==".equals(string)) {
            return Equality.INSTANCE;
        }
        if ("!=".equals(string)) {
            return Inequality.INSTANCE;
        }
        if (string.startsWith("+")) {
            return AtomicConcept.create(this.m_debugger.getPrefixes().expandAbbreviatedIRI(string.substring(1)));
        }
        if (string.startsWith("-")) {
            return AtomicRole.create(this.m_debugger.getPrefixes().expandAbbreviatedIRI(string.substring(1)));
        }
        if (string.startsWith("$")) {
            String string2 = this.m_debugger.getPrefixes().expandAbbreviatedIRI(string.substring(1));
            for (DescriptionGraph descriptionGraph : this.m_debugger.getTableau().getPermanentDLOntology().getAllDescriptionGraphs()) {
                if (!string2.equals(descriptionGraph.getName())) continue;
                return descriptionGraph;
            }
            return null;
        }
        return null;
    }

    protected static String formatBlockingStatus(Node node) {
        if (!node.isBlocked()) {
            return "no";
        }
        if (node.isDirectlyBlocked()) {
            return "directly by " + (node.getBlocker() == Node.SIGNATURE_CACHE_BLOCKER ? "signature in cache" : Integer.valueOf(node.getBlocker().getNodeID()));
        }
        return "indirectly by " + (node.getBlocker() == Node.SIGNATURE_CACHE_BLOCKER ? "signature in cache" : Integer.valueOf(node.getBlocker().getNodeID()));
    }
}

