/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.anyuri;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.Datatypes;
import dk.brics.automaton.RegExp;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyURIValueSpaceSubset
implements ValueSpaceSubset {
    protected static final Automaton s_anyChar = BasicAutomata.makeAnyChar();
    protected static final Automaton s_anyString = BasicAutomata.makeAnyString();
    protected static final Automaton s_anyURI = Datatypes.get((String)"URI");
    protected static final Automaton s_empty = BasicAutomata.makeEmpty();
    protected final Automaton m_automaton;

    public AnyURIValueSpaceSubset(Automaton automaton) {
        this.m_automaton = automaton;
    }

    @Override
    public boolean hasCardinalityAtLeast(int n) {
        Set set = this.m_automaton.getFiniteStrings(n);
        if (set == null) {
            return true;
        }
        return set.size() >= n;
    }

    @Override
    public boolean containsDataValue(Object object) {
        if (object instanceof URI) {
            return this.m_automaton.run(object.toString());
        }
        return false;
    }

    @Override
    public void enumerateDataValues(Collection<Object> collection) {
        Set set = this.m_automaton.getFiniteStrings();
        if (set == null) {
            throw new IllegalStateException("The value space range is infinite.");
        }
        for (String string : set) {
            collection.add(URI.create(string));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("xsd:anyURI{");
        stringBuffer.append(this.m_automaton.toString());
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static Automaton toAutomaton(int n, int n2) {
        assert (n <= n2);
        if (n2 == Integer.MAX_VALUE) {
            if (n == 0) {
                return s_anyString;
            }
            return s_anyString.intersection(BasicOperations.repeat((Automaton)s_anyChar, (int)n));
        }
        return s_anyString.intersection(BasicOperations.repeat((Automaton)s_anyChar, (int)n, (int)n2));
    }

    public static boolean isValidPattern(String string) {
        try {
            new RegExp(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static Automaton getPatternAutomaton(String string) {
        return new RegExp(string).toAutomaton();
    }
}

