/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.datatypes.DatatypeHandler;
import org.semanticweb.HermiT.datatypes.MalformedLiteralException;
import org.semanticweb.HermiT.datatypes.UnsupportedDatatypeException;
import org.semanticweb.HermiT.datatypes.UnsupportedFacetException;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.anyuri.AnyURIDatatypeHandler;
import org.semanticweb.HermiT.datatypes.binarydata.BinaryDataDatatypeHandler;
import org.semanticweb.HermiT.datatypes.bool.BooleanDatatypeHandler;
import org.semanticweb.HermiT.datatypes.datetime.DateTimeDatatypeHandler;
import org.semanticweb.HermiT.datatypes.doublenum.DoubleDatatypeHandler;
import org.semanticweb.HermiT.datatypes.floatnum.FloatDatatypeHandler;
import org.semanticweb.HermiT.datatypes.owlreal.OWLRealDatatypeHandler;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralDatatypeHandler;
import org.semanticweb.HermiT.datatypes.xmlliteral.XMLLiteralDatatypeHandler;
import org.semanticweb.HermiT.model.DatatypeRestriction;

public class DatatypeRegistry {
    protected static final Map<String, DatatypeHandler> s_handlersByDatatypeURI = new HashMap<String, DatatypeHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDatatypeHandler(DatatypeHandler datatypeHandler) {
        Map<String, DatatypeHandler> map = s_handlersByDatatypeURI;
        synchronized (map) {
            for (String string : datatypeHandler.getManagedDatatypeURIs()) {
                if (!s_handlersByDatatypeURI.containsKey(string)) continue;
                throw new IllegalArgumentException("Datatype handler for datatype '" + string + "' has already been registed.");
            }
            for (String string : datatypeHandler.getManagedDatatypeURIs()) {
                s_handlersByDatatypeURI.put(string, datatypeHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DatatypeHandler getDatatypeHandlerFor(String string) throws UnsupportedDatatypeException {
        DatatypeHandler datatypeHandler;
        Object object = s_handlersByDatatypeURI;
        synchronized (object) {
            datatypeHandler = s_handlersByDatatypeURI.get(string);
        }
        if (datatypeHandler == null) {
            object = System.getProperty("line.separator");
            String string2 = "HermiT supports all and only the datatypes of the OWL 2 datatype map, see " + (String)object + "http://www.w3.org/TR/owl2-syntax/#Datatype_Maps. " + (String)object + "The datatype '" + string + "' is not part of the OWL 2 datatype map and " + (String)object + "no custom datatype definition is given; " + (String)object + "therefore, HermiT cannot handle this datatype.";
            throw new UnsupportedDatatypeException(string2);
        }
        return datatypeHandler;
    }

    protected static DatatypeHandler getDatatypeHandlerFor(DatatypeRestriction datatypeRestriction) throws UnsupportedDatatypeException {
        return DatatypeRegistry.getDatatypeHandlerFor(datatypeRestriction.getDatatypeURI());
    }

    public static Object parseLiteral(String string, String string2) throws MalformedLiteralException, UnsupportedDatatypeException {
        return DatatypeRegistry.getDatatypeHandlerFor(string2).parseLiteral(string, string2);
    }

    public static void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedDatatypeException, UnsupportedFacetException {
        DatatypeRegistry.getDatatypeHandlerFor(datatypeRestriction).validateDatatypeRestriction(datatypeRestriction);
    }

    public static ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
        return DatatypeRegistry.getDatatypeHandlerFor(datatypeRestriction).createValueSpaceSubset(datatypeRestriction);
    }

    public static ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        return DatatypeRegistry.getDatatypeHandlerFor(datatypeRestriction).conjoinWithDR(valueSpaceSubset, datatypeRestriction);
    }

    public static ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        return DatatypeRegistry.getDatatypeHandlerFor(datatypeRestriction).conjoinWithDRNegation(valueSpaceSubset, datatypeRestriction);
    }

    public static boolean isSubsetOf(String string, String string2) {
        DatatypeHandler datatypeHandler = DatatypeRegistry.getDatatypeHandlerFor(string);
        if (datatypeHandler.getManagedDatatypeURIs().contains(string2)) {
            return datatypeHandler.isSubsetOf(string, string2);
        }
        return false;
    }

    public static boolean isDisjointWith(String string, String string2) {
        DatatypeHandler datatypeHandler = DatatypeRegistry.getDatatypeHandlerFor(string);
        if (datatypeHandler.getManagedDatatypeURIs().contains(string2)) {
            return datatypeHandler.isDisjointWith(string, string2);
        }
        return true;
    }

    static {
        DatatypeRegistry.registerDatatypeHandler(new AnonymousConstantsDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new BooleanDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new RDFPlainLiteralDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new OWLRealDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new DoubleDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new FloatDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new DateTimeDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new BinaryDataDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new AnyURIDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new XMLLiteralDatatypeHandler());
    }

    public static class AnonymousConstantValue {
        private static final long serialVersionUID = -6507581477324043034L;
        protected final String m_name;

        public AnonymousConstantValue(String string) {
            this.m_name = string;
        }

        public String getName() {
            return this.m_name;
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AnonymousConstantValue)) {
                return false;
            }
            return ((AnonymousConstantValue)object).m_name.equals(this.m_name);
        }

        public static AnonymousConstantValue create(String string) {
            return new AnonymousConstantValue(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AnonymousConstantsDatatypeHandler
    implements DatatypeHandler {
        protected static final String ANONYMOUS_CONSTANTS = "internal:anonymous-constants";
        protected static final Set<String> s_managedDatatypeURIs = Collections.singleton("internal:anonymous-constants");

        protected AnonymousConstantsDatatypeHandler() {
        }

        @Override
        public Set<String> getManagedDatatypeURIs() {
            return s_managedDatatypeURIs;
        }

        @Override
        public Object parseLiteral(String string, String string2) throws MalformedLiteralException {
            assert (ANONYMOUS_CONSTANTS.equals(string2));
            return new AnonymousConstantValue(string.trim());
        }

        @Override
        public void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedFacetException {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }

        @Override
        public ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }

        @Override
        public ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }

        @Override
        public ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }

        @Override
        public boolean isSubsetOf(String string, String string2) {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }

        @Override
        public boolean isDisjointWith(String string, String string2) {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }
    }
}

