## ----style, eval=TRUE, echo=FALSE, results="asis"---------------------------------------
BiocStyle::latex()

## ----installation-github,eval=FALSE-----------------------------------------------------
#  library("devtools")
#  install_github("zhengxwen/gdsfmt")

## ----create-gds-------------------------------------------------------------------------
library(gdsfmt)
gfile <- createfn.gds("test.gds")

## ----echo=FALSE-------------------------------------------------------------------------
set.seed(1000)

## ----create-var-folder------------------------------------------------------------------
add.gdsn(gfile, "int", val=1:10000)
add.gdsn(gfile, "double", val=seq(1, 1000, 0.4))
add.gdsn(gfile, "character", val=c("int", "double", "logical", "factor"))
add.gdsn(gfile, "logical", val=rep(c(TRUE, FALSE, NA), 50), visible=FALSE)
add.gdsn(gfile, "factor", val=as.factor(c(NA, "AA", "CC")), visible=FALSE)
add.gdsn(gfile, "bit2", val=sample(0:3, 1000, replace=TRUE), storage="bit2")


# list and data.frame
add.gdsn(gfile, "list", val=list(X=1:10, Y=seq(1, 10, 0.25)))
add.gdsn(gfile, "data.frame", val=data.frame(X=1:19, Y=seq(1, 10, 0.5)))

## ----create-var-folder-1----------------------------------------------------------------
folder <- addfolder.gdsn(gfile, "folder")
add.gdsn(folder, "int", val=1:1000)
add.gdsn(folder, "double", val=seq(1, 100, 0.4), visible=FALSE)

## ----display-gds------------------------------------------------------------------------
gfile

## ----display-gds-print------------------------------------------------------------------
print(gfile, all=TRUE)

## ---------------------------------------------------------------------------------------
index.gdsn(gfile, "int")
index.gdsn(gfile, "list/Y")
index.gdsn(gfile, "folder/int")

## ----close-gds--------------------------------------------------------------------------
# close the GDS file
closefn.gds(gfile)

## ---------------------------------------------------------------------------------------
gfile <- createfn.gds("test.gds")

## ---------------------------------------------------------------------------------------
(n <- add.gdsn(gfile, "I1", val=matrix(1:15, nrow=3)))
read.gdsn(n)

## ---------------------------------------------------------------------------------------
write.gdsn(n, rep(0,5), start=c(2,1), count=c(1,-1))
read.gdsn(n)

## ---------------------------------------------------------------------------------------
append.gdsn(n, 16:24)
read.gdsn(n)

## ---------------------------------------------------------------------------------------
(n2 <- add.gdsn(gfile, "I2", storage="int", valdim=c(100, 2000)))

for (i in 1:2000)
{
    write.gdsn(n2, seq.int(100*(i-1)+1, length.out=100),
        start=c(1,i), count=c(-1,1))
}

## ---------------------------------------------------------------------------------------
(n3 <- add.gdsn(gfile, "I3", storage="int", valdim=c(100, 0), compress="ZIP"))

for (i in 1:2000)
{
    append.gdsn(n3, seq.int(100*(i-1)+1, length.out=100))
}

n3

## ---------------------------------------------------------------------------------------
# close the GDS file
closefn.gds(gfile)

## ---------------------------------------------------------------------------------------
gfile <- createfn.gds("test.gds")
(n <- add.gdsn(gfile, "I1", val=matrix(1:20, nrow=4)))
read.gdsn(n)

## ---------------------------------------------------------------------------------------
# read a subset
read.gdsn(n, start=c(2, 2), count=c(2, 3))

## ---------------------------------------------------------------------------------------
# read a subset
readex.gdsn(n, list(c(FALSE,TRUE,TRUE,FALSE), c(TRUE,FALSE,TRUE,FALSE,TRUE)))

## ---------------------------------------------------------------------------------------
apply.gdsn(n, margin=1, FUN=print, as.is="none")

## ---------------------------------------------------------------------------------------
apply.gdsn(n, margin=2, FUN=print, as.is="none")

## ---------------------------------------------------------------------------------------
n.t <- add.gdsn(gfile, "transpose", storage="int", valdim=c(5,0))

# apply the function over rows of matrix
apply.gdsn(n, margin=1, FUN=c, as.is="gdsnode", target.node=n.t)

# matrix transpose
read.gdsn(n.t)

## ---------------------------------------------------------------------------------------
# close the GDS file
closefn.gds(gfile)

## ----sessioninfo, results="asis"--------------------------------------------------------
toLatex(sessionInfo())

