### R code from vignette source 'flowMap.Rnw'

###################################################
### code chunk number 1: options (eval = FALSE)
###################################################
## options(width=70)


###################################################
### code chunk number 2: showData1
###################################################
sam1 <- read.table(system.file("extdata/sample1.txt"
            ,package="flowMap"),header=T)
str(sam1)


###################################################
### code chunk number 3: showData2
###################################################
sam1 <- read.table(system.file("extdata/sample1.txt"
                ,package="flowMap"),header=T)
sam2 <- read.table(system.file("extdata/sample2.txt"
                ,package="flowMap"),header=T)
table(sam1$id)
table(sam2$id)


###################################################
### code chunk number 4: compareTwoSamples
###################################################
require(flowMap)
res1 <- FRmappingSimple(samples=list(sam1),centroids=NULL,
          refSample=sam2,refCentroid=NULL,nPopFilt=NULL,draws=5,cutoff=10^(-5),
          sampleMethod="equalSize",sampleSize=100,nperm=300)    


###################################################
### code chunk number 5: getEstFR
###################################################
str(getFRmapStats(res1))


###################################################
### code chunk number 6: plotTwoSampleFRs
###################################################
datToPlot <- melt(getFRmapStats(res1)[[1]])
colnames(datToPlot) <- c("X1","X2","value")
datToPlot$value[is.na(datToPlot$value)] <- -200
pp <- ggplot(datToPlot, aes(factor(X2), factor(X1,levels=rev(sort(unique(datToPlot$X1))) ) ) ) +
  coord_fixed() + geom_tile(aes(fill = value),colour="black") + 
   scale_fill_gradientn("FR statistics",colours=c("darkblue","blue","dodgerblue2",
   											   "deepskyblue","cyan1","cadetblue1","aliceblue","white"),
             							 values=rescale(c(2,1,0,-1,-2,-3,-4,-5)),
 	            						 guide="colorbar",limits=c(-15,3)) + 
   labs(x="Sample 2",y="Sample 1") 
print(pp)


###################################################
### code chunk number 7: getPvals
###################################################
str(getFRmapPnorms(res1))
str(getFRmapPnulls(res1))


###################################################
### code chunk number 8: listRes1
###################################################
getCrossList(res1)


###################################################
### code chunk number 9: sessionInfo
###################################################
toLatex(sessionInfo())


###################################################
### code chunk number 10: closeSockets
###################################################
closeSockets <- function() {
    allCon <- showConnections()
    socketCon <- as.integer(rownames(allCon)[allCon[, "class"] == "sockconn"])
    sapply(socketCon, function(ii) close.connection(getConnection(ii)) )
}
closeSockets()


