### R code from vignette source 'flipflop.Rnw'

###################################################
### code chunk number 1: lib
###################################################
library(flipflop)


###################################################
### code chunk number 2: data
###################################################
data.file <- system.file(file.path('extdata', 'vignette-sam.txt'), package='flipflop')


###################################################
### code chunk number 3: estim
###################################################
# The minimum number of clustered reads
# to consider a cluster of reads as a gene (default 40): 
min.read <- 50
# The maximum number of isoforms given
# during regularization path (default 10):
max.iso <- 7 
ff.res <- flipflop(data.file=data.file, 
                   out.file='FlipFlop_output.gtf',
		   minReadNum=min.read,
                   max_isoforms=max.iso) 


###################################################
### code chunk number 4: names
###################################################
names(ff.res)


###################################################
### code chunk number 5: output
###################################################
transcripts <- ff.res$transcripts[[1]]
abundancesFPKM <- ff.res$abundancesFPKM[[1]]
expected.counts <- ff.res$expected.counts[[1]]
print(transcripts)
print(abundancesFPKM)
print(expected.counts)


###################################################
### code chunk number 6: annot
###################################################
annot.file <- system.file(file.path('extdata', 'vignette-annot.bed.txt'), 
                          package='flipflop')


###################################################
### code chunk number 7: estim_annot
###################################################
ff.res.annot <- flipflop(data.file=data.file, 
                   out.file='FlipFlop_output.gtf',
		   annot.file=annot.file)


###################################################
### code chunk number 8: output_annot
###################################################
transcripts.annot <- ff.res.annot$transcripts[[1]]
print(transcripts.annot)


###################################################
### code chunk number 9: GenomicFeatures
###################################################
if(require(GenomicFeatures)){
   txdb <- makeTranscriptDbFromGFF(file='FlipFlop_output.gtf', 
				format='gtf', 
				exonRankAttributeName='exon_number')
   # List of exons for each transcript:
   exonsBy(txdb, by='tx')
}


###################################################
### code chunk number 10: sessionInfo
###################################################
sessionInfo()


