## ----vignetteSetup, echo=FALSE, message=FALSE, warning = FALSE-----------
## Track time spent on making the vignette
startTime <- Sys.time()

## Bib setup
library('knitcitations')

## Load knitcitations with a clean bibliography
cleanbib()
cite_options(hyperlink = 'to.doc', citation_format = 'text', style = 'html')
# Note links won't show for now due to the following issue
# https://github.com/cboettig/knitcitations/issues/63

## Write bibliography information
write.bibtex(c(knitcitations = citation('knitcitations'),
    derfinder = citation('derfinder')[1], 
    knitrBootstrap = citation('knitrBootstrap'), 
    knitr = citation('knitr')[3],
    rmarkdown = citation('rmarkdown')),
    file = 'derfinderRef.bib')
bib <- read.bibtex('derfinderRef.bib')

## Assign short names
names(bib) <- c('knitcitations', 'derfinder', 'knitrBootstrap',
    'knitr', 'rmarkdown')

## ------------------------------------------------------------------------
library('derfinderData')

## ----createVignette, eval=FALSE, bootstrap.show.code=FALSE---------------
#  ## Create the vignette
#  library('knitrBootstrap')
#  
#  knitrBootstrapFlag <- packageVersion('knitrBootstrap') < '1.0.0'
#  if(knitrBootstrapFlag) {
#      ## CRAN version
#      library('knitrBootstrap')
#      system.time(knit_bootstrap('derfinder.Rmd', chooser=c('boot', 'code'), show_code = TRUE))
#      unlink('derfinder.md')
#  } else {
#      ## GitHub version
#      library('rmarkdown')
#      system.time(render('derfinder.Rmd', 'knitrBootstrap::bootstrap_document'))
#  }
#  ## Note: if you prefer the knitr version use:
#  # library('rmarkdown')
#  # system.time(render('derfinder.Rmd', 'html_document'))
#  
#  ## Extract the R code
#  library('knitr')
#  knit('derfinder.Rmd', tangle = TRUE)

## ----reproducibility1, echo=FALSE, bootstrap.show.code=FALSE-------------
## Date the vignette was generated
Sys.time()

## ----reproducibility2, echo=FALSE, bootstrap.show.code=FALSE-------------
## Processing time in seconds
totalTime <- diff(c(startTime, Sys.time()))
round(totalTime, digits=3)

## ----reproducibility3, echo=FALSE, bootstrap.show.code=FALSE, bootstrap.show.message=FALSE----
## Session info
library('devtools')
session_info()

## ----vignetteBiblio, results='asis', echo=FALSE--------------------------
## Print bibliography
bibliography()

