### R code from vignette source 'cleanUpdTSeq.Rnw'

###################################################
### code chunk number 1: 1
###################################################
library(cleanUpdTSeq)
testFile <- system.file("extdata", "test.bed", package="cleanUpdTSeq")
testSet <- read.table(testFile, sep="\t", header=TRUE)
peaks <- BED2GRangesSeq(testSet, withSeq=FALSE)


###################################################
### code chunk number 2: 2
###################################################
peaks <- BED2GRangesSeq(testSet, upstream.seq.ind=7, 
                          downstream.seq.ind=8, withSeq=TRUE)


###################################################
### code chunk number 3: 3
###################################################
head(testSet)


###################################################
### code chunk number 4: 4
###################################################
testSet.NaiveBayes <- buildFeatureVector(peaks, BSgenomeName=Drerio,
                                         upstream=40, downstream=30, 
                                         wordSize=6, alphabet=c("ACGT"),
                                         sampleType="unknown", 
                                         replaceNAdistance=30, 
                                         method="NaiveBayes",
                                         ZeroBasedIndex=1, fetchSeq=TRUE)


###################################################
### code chunk number 5: 5
###################################################
data(data.NaiveBayes)
if(interactive()){
    predictTestSet(data.NaiveBayes$Negative, data.NaiveBayes$Positive, 
                   testSet.NaiveBayes=testSet.NaiveBayes, 
                   outputFile="test-predNaiveBayes.tsv", 
                   assignmentCutoff=0.5)
}


###################################################
### code chunk number 6: cleanUpdTSeq.Rnw:107-108
###################################################
sessionInfo()


