### R code from vignette source 'crlmmDownstream.Rnw'

###################################################
### code chunk number 1: loadData
###################################################
library(oligoClasses)
library(VanillaICE)
library(crlmm)
library(SNPchip)
library(IRanges)
library(foreach)


###################################################
### code chunk number 2: data
###################################################
data(cnSetExample, package="crlmm")


###################################################
### code chunk number 3: snow (eval = FALSE)
###################################################
## ##registerDoSEQ()
## library(snow)
## library(doSNOW)
## cl <- makeCluster(2, type="SOCK")
## registerDoSNOW(cl)
## ocSamples(2)


###################################################
### code chunk number 4: crlmmDownstream.Rnw:60-61
###################################################
registerDoSEQ()


###################################################
### code chunk number 5: parse_cnSet
###################################################
se <- as(cnSetExample, "SnpArrayExperiment")


###################################################
### code chunk number 6: windowselection
###################################################
library(ArrayTV)
i <- seq_len(ncol(se))
increms <- c(10,1000,100e3)
wins <- c(100,10e3,1e6)
res <- gcCorrect(lrr(se),
                 increms=increms,
                 maxwins=wins,
                 returnOnlyTV=FALSE,
                 verbose=TRUE,
                 build="hg18",
                 chr=chromosome(se),
                 starts=start(se))
se2 <- se
assays(se2)[["cn"]] <- res$correctedVals


###################################################
### code chunk number 7: hmm
###################################################
res <- hmm2(se2)


###################################################
### code chunk number 8: crlmmDownstream.Rnw:148-149
###################################################
toLatex(sessionInfo())


