## ----knitr, include=FALSE, cache=FALSE-----------------------------------
library(knitr)
opts_chunk$set(fig.align='center', fig.show='hold')

## ----<style, eval=TRUE, echo=FALSE, results="asis"--------------------------------------
BiocStyle::latex()

## ----message=FALSE----------------------------------------------------------------------
library(SGSeq)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)

## ---------------------------------------------------------------------------------------
dir <- system.file("extdata", package = "SGSeq")
si$file_bam <- file.path(dir, "bams", si$file_bam)

## ---------------------------------------------------------------------------------------
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
txdb <- keepSeqlevels(txdb, "chr16")
seqlevelsStyle(txdb) <- "NCBI"

## ---------------------------------------------------------------------------------------
txf_annotated <- convertToTxFeatures(txdb)
txf_annotated <- txf_annotated[txf_annotated %over% gr]

## ---------------------------------------------------------------------------------------
sgfc <- analyzeFeatures(si, features = txf_annotated)

## ----figure-1, fig.width=4.5, fig.height=4.5--------------------------------------------
plotFeatures(sgfc, geneID = 1)

## ---------------------------------------------------------------------------------------
sgfc <- analyzeFeatures(si, which = gr)

## ---------------------------------------------------------------------------------------
sgfc <- annotate(sgfc, txf_annotated)

## ----figure-2, fig.width=4.5, fig.height=4.5--------------------------------------------
plotFeatures(sgfc, geneID = 1)

## ---------------------------------------------------------------------------------------
txvc <- analyzeVariants(sgfc)

## ---------------------------------------------------------------------------------------
mcols(txvc)

## ----figure-3, fig.width=1.5, fig.height=4.5--------------------------------------------
plotVariants(txvc, eventID = 1)

## ---------------------------------------------------------------------------------------
txf <- predictTxFeatures(si, gr)
sgf <- convertToSGFeatures(txf)
sgf <- annotate(sgf, txf_annotated)
sgfc <- getSGFeatureCounts(si, sgf)
txv <- findTxVariants(sgf)
txvc <- getTxVariantCounts(sgfc, txv)

## ----results="asis", echo=FALSE---------------------------------------------------------
toLatex(sessionInfo())

