# Rsamtools

# order of -llib important -- bcf, bam before ws2_32

SAMTOOLS_PATH=\
    $(shell echo 'cat(system.file("usrlib", .Platform[["r_arch"]],\
        	                 package="Rsamtools", mustWork=TRUE))'|\
	                 "${R_HOME}/bin/R" --vanilla --slave)
PKG_LIBS+="$(SAMTOOLS_PATH)/libbam.a" "$(SAMTOOLS_PATH)/libbam.a"\
    "$(SAMTOOLS_PATH)/libbcf.a" "$(SAMTOOLS_PATH)/libtabix.a"\
    -lws2_32 -pthread
PKG_CPPFLAGS+=-D_USE_KNETFILE -D_FILE_OFFSET_BITS=64 \
	-D_LARGEFILE64_SOURCE

# zlib

ZLIB_CFLAGS+=$(shell echo 'zlibbioc::pkgconfig("PKG_CFLAGS")'|\
    "${R_HOME}/bin/R" --vanilla --slave)
PKG_LIBS+=$(shell echo 'zlibbioc::pkgconfig("PKG_LIBS_shared")' |\
    "${R_HOME}/bin/R" --vanilla --slave)

%.o: %.c
	$(CC) $(ZLIB_CFLAGS) $(ALL_CPPFLAGS) $(ALL_CFLAGS) -c $< -o $@
%.o: %.cc
	$(CXX) $(ZLIB_CFLAGS) $(ALL_CPPFLAGS) $(ALL_CXXFLAGS) -c $< -o $@
%.o: %.cpp
	$(CXX) $(ZLIB_CFLAGS) $(ALL_CPPFLAGS) $(ALL_CXXFLAGS) -c $< -o $@
