/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis.directed;

import java.io.File;
import net.sf.picard.analysis.directed.HsMetricsCalculator;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.samtools.SAMFileReader;

public class CalculateHsMetrics
extends CommandLineProgram {
    @Usage
    public final String USAGE = "Calculates a set of Hybrid Selection specific metrics from an aligned SAMor BAM file.";
    @Option(shortName="BI", doc="An interval list file that contains the locations of the baits used.")
    public File BAIT_INTERVALS;
    @Option(shortName="TI", doc="An interval list file that contains the locations of the targets.")
    public File TARGET_INTERVALS;
    @Option(shortName="I", doc="An aligned SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="The output file to write the metrics to.")
    public File OUTPUT;
    @Option(shortName="M", mutex={"OUTPUT"}, doc="Legacy synonym for OUTPUT, should not be used.")
    public File METRICS_FILE;

    public static void main(String[] argv) {
        System.exit(new CalculateHsMetrics().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        if (this.OUTPUT == null) {
            this.OUTPUT = this.METRICS_FILE;
        }
        IoUtil.assertFileIsReadable(this.BAIT_INTERVALS);
        IoUtil.assertFileIsReadable(this.TARGET_INTERVALS);
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        HsMetricsCalculator calculator = new HsMetricsCalculator(this.BAIT_INTERVALS, this.TARGET_INTERVALS);
        SAMFileReader sam = new SAMFileReader(this.INPUT);
        calculator.analyze(sam.iterator());
        MetricsFile metrics = this.getMetricsFile();
        metrics.addMetric(calculator.getMetrics());
        metrics.write(this.OUTPUT);
        return 0;
    }
}

