/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordComparator;

public class SAMRecordQueryNameComparator
implements SAMRecordComparator {
    @Override
    public int compare(SAMRecord samRecord1, SAMRecord samRecord2) {
        int cmp = this.fileOrderCompare(samRecord1, samRecord2);
        if (cmp != 0) {
            return cmp;
        }
        boolean r1Paired = samRecord1.getReadPairedFlag();
        boolean r2Paired = samRecord2.getReadPairedFlag();
        if (r1Paired || r2Paired) {
            if (!r1Paired) {
                return 1;
            }
            if (!r2Paired) {
                return -1;
            }
            if (samRecord1.getFirstOfPairFlag() && samRecord2.getSecondOfPairFlag()) {
                return -1;
            }
            if (samRecord1.getSecondOfPairFlag() && samRecord2.getFirstOfPairFlag()) {
                return 1;
            }
        }
        if (samRecord1.getReadNegativeStrandFlag() == samRecord2.getReadNegativeStrandFlag()) {
            return 0;
        }
        return samRecord1.getReadNegativeStrandFlag() ? 1 : -1;
    }

    @Override
    public int fileOrderCompare(SAMRecord samRecord1, SAMRecord samRecord2) {
        return samRecord1.getReadName().compareTo(samRecord2.getReadName());
    }
}

