### R code from vignette source 'Rchemcpp.Rnw'

###################################################
### code chunk number 1: Rchemcpp.Rnw:37-41
###################################################
options(width=75)
set.seed(0)
library(Rchemcpp)
RchemcppVersion <- packageDescription("Rchemcpp")$Version


###################################################
### code chunk number 2: Rchemcpp.Rnw:97-98
###################################################
library(Rchemcpp)


###################################################
### code chunk number 3: Rchemcpp.Rnw:105-108
###################################################
sdfolder <- system.file("extdata",package="Rchemcpp")
sdf <- list.files(sdfolder,full.names=TRUE,pattern="small")
K <- sd2gram(sdf)


###################################################
### code chunk number 4: Rchemcpp.Rnw:114-115 (eval = FALSE)
###################################################
## heatmap(K,Rowv=NA,Colv=NA,scale="none")


###################################################
### code chunk number 5: Rchemcpp.Rnw:119-122
###################################################
pdf("001.pdf")
heatmap(K,Rowv=NA,Colv=NA,scale="none",margins=c(12,12))
dev.off()


###################################################
### code chunk number 6: Rchemcpp.Rnw:141-143
###################################################
library(apcluster)
r <- apcluster(K)


###################################################
### code chunk number 7: Rchemcpp.Rnw:147-148 (eval = FALSE)
###################################################
## heatmap(r,K)


###################################################
### code chunk number 8: Rchemcpp.Rnw:151-154
###################################################
pdf("002.pdf")
heatmap(r,K,margins=c(12,12))
dev.off()


###################################################
### code chunk number 9: Rchemcpp.Rnw:173-182
###################################################
library(kernlab)
chromosomeAberrationDataSet <- list.files(sdfolder,
		full.names=TRUE,pattern="Mohr.sdf")
KCA <- sd2gramSpectrum(chromosomeAberrationDataSet,
		detectArom=FALSE,depthMax=4,silentMode=TRUE)
response <- getMoleculePropertyFromSDF(chromosomeAberrationDataSet,
		"chromosome_damage")
# C was set to 0.1 for computational speed - should be set to a higher value
model <- ksvm(KCA,y=as.factor(response),kernel="matrix",cross=10,type="C-svc",C=0.1)


###################################################
### code chunk number 10: Rchemcpp.Rnw:186-187
###################################################
print(1-model@cross)


###################################################
### code chunk number 11: Rchemcpp.Rnw:192-193
###################################################
predict(model,as.kernelMatrix(KCA[3,SVindex(model),drop=FALSE]))


###################################################
### code chunk number 12: Rchemcpp.Rnw:202-206
###################################################
library(ChemmineR)
sdfFileName <- list.files(sdfolder,full.names=TRUE,pattern="small")
sdfSet <- read.SDFset(sdfFileName)
plot(sdfSet[2],print=FALSE)


###################################################
### code chunk number 13: Rchemcpp.Rnw:210-211
###################################################
K1 <- sd2gramSubtree(sdfSet,silentMode=TRUE)


###################################################
### code chunk number 14: Rchemcpp.Rnw:218-221
###################################################
leadCompound <- sdfSet[1]
compoundDataBase <- sdfSet[1:20]
K2 <- sd2gramSubtree(leadCompound,compoundDataBase,silentMode=TRUE)


###################################################
### code chunk number 15: Rchemcpp.Rnw:471-472 (eval = FALSE)
###################################################
## toBibtex(citation("Rchemcpp"))


