/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.utils.DataHandlerUtils;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.builder.XOPBuilder;
import org.apache.axiom.om.impl.dom.CharacterImpl;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.axiom.util.stax.XMLStreamWriterUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public abstract class TextNodeImpl
extends CharacterImpl
implements Text,
OMText {
    private String mimeType;
    private boolean optimize;
    private boolean isBinary;
    private String contentID = null;
    protected OMNamespace textNS = null;
    protected char[] charArray;
    private Object dataHandlerObject = null;
    protected OMNamespace ns = null;
    public static final OMNamespace XOP_NS = new OMNamespaceImpl("http://www.w3.org/2004/08/xop/include", "xop");

    public TextNodeImpl(String text, OMFactory factory) {
        super(factory);
        this.textValue = text != null ? new StringBuffer(text) : new StringBuffer("");
        this.done = true;
        this.ns = XOP_NS;
    }

    public TextNodeImpl(String contentID, OMContainer parent, OMXMLParserWrapper builder, OMFactory factory) {
        super((DocumentImpl)((ParentNode)parent).getOwnerDocument(), factory);
        this.contentID = contentID;
        this.optimize = true;
        this.isBinary = true;
        this.done = true;
        this.builder = builder;
        this.ns = XOP_NS;
    }

    public TextNodeImpl(OMContainer parent, TextNodeImpl source, OMFactory factory) {
        super((DocumentImpl)((ParentNode)parent).getOwnerDocument(), factory);
        this.done = true;
        if (source.textValue != null) {
            this.textValue = new StringBuffer();
            this.textValue.append(source.textValue.toString());
        }
        if (source.charArray != null) {
            this.charArray = new char[source.charArray.length];
            for (int i = 0; i < source.charArray.length; ++i) {
                this.charArray[i] = source.charArray[i];
            }
        }
        this.textNS = null;
        this.optimize = source.optimize;
        this.mimeType = source.mimeType;
        this.isBinary = source.isBinary;
        this.contentID = source.contentID;
        this.dataHandlerObject = source.dataHandlerObject;
        if (source.ns != null) {
            this.ns = new OMNamespaceImpl(source.ns.getNamespaceURI(), source.ns.getPrefix());
        }
    }

    public TextNodeImpl(String text, String mimeType, boolean optimize, OMFactory factory) {
        this(text, mimeType, optimize, true, factory);
    }

    public TextNodeImpl(String text, String mimeType, boolean optimize, boolean isBinary, OMFactory factory) {
        this(text, factory);
        this.mimeType = mimeType;
        this.optimize = optimize;
        this.isBinary = isBinary;
    }

    public TextNodeImpl(DocumentImpl ownerNode, Object dataHandler, boolean optimize, OMFactory factory) {
        super(ownerNode, factory);
        this.dataHandlerObject = dataHandler;
        this.isBinary = true;
        this.optimize = optimize;
        this.done = true;
        this.ns = XOP_NS;
    }

    public TextNodeImpl(DocumentImpl ownerNode, String contentID, DataHandlerProvider dataHandlerProvider, boolean optimize, OMFactory factory) {
        super(ownerNode, factory);
        this.contentID = contentID;
        this.dataHandlerObject = dataHandlerProvider;
        this.isBinary = true;
        this.optimize = optimize;
        this.done = true;
    }

    public TextNodeImpl(DocumentImpl ownerNode, OMFactory factory) {
        super(ownerNode, factory);
        this.done = true;
        this.ns = XOP_NS;
    }

    public TextNodeImpl(DocumentImpl ownerNode, String value, OMFactory factory) {
        super(ownerNode, value, factory);
        this.done = true;
        this.ns = XOP_NS;
    }

    public TextNodeImpl(DocumentImpl ownerNode, char[] value, OMFactory factory) {
        super(ownerNode, factory);
        this.charArray = value;
        this.done = true;
        this.ns = XOP_NS;
    }

    public TextNodeImpl(DocumentImpl ownerNode, String value, String mimeType, boolean optimize, OMFactory factory) {
        this(ownerNode, value, factory);
        this.mimeType = mimeType;
        this.optimize = optimize;
        this.isBinary = true;
        this.done = true;
    }

    public TextNodeImpl(OMContainer parent, QName text, OMFactory factory) {
        this(parent, text, 4, factory);
    }

    public TextNodeImpl(OMContainer parent, QName text, int nodeType, OMFactory factory) {
        this(((ElementImpl)parent).ownerNode, factory);
        if (text != null) {
            this.textNS = ((ElementImpl)parent).findNamespace(text.getNamespaceURI(), text.getPrefix());
        }
        this.textValue = new StringBuffer(text == null ? "" : text.getLocalPart());
        this.done = true;
    }

    public Text splitText(int offset) throws DOMException {
        if (this.isReadonly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (offset < 0 || offset > this.textValue.length()) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        String newValue = this.textValue.substring(offset);
        this.deleteData(offset, this.textValue.length());
        TextImpl newText = (TextImpl)this.getOwnerDocument().createTextNode(newValue);
        if (this.parentNode != null) {
            newText.setParent((OMContainer)this.parentNode);
        }
        this.insertSiblingAfter((OMNode)newText);
        return newText;
    }

    public String getNodeName() {
        return "#text";
    }

    public short getNodeType() {
        return 3;
    }

    public boolean isOptimized() {
        return this.optimize;
    }

    public void setOptimize(boolean value) {
        this.optimize = value;
        if (value) {
            this.isBinary = true;
        }
    }

    public void discard() throws OMException {
        if (this.done) {
            this.detach();
        }
    }

    private void writeOutput(XMLStreamWriter writer) throws XMLStreamException {
        int type = this.getType();
        if (type == 4 || type == 6) {
            writer.writeCharacters(this.getText());
        } else if (type == 12) {
            writer.writeCData(this.getText());
        } else if (type == 9) {
            writer.writeEntityRef(this.getText());
        }
    }

    public String getText() {
        if (this.textNS != null) {
            return this.getTextString();
        }
        if (this.charArray != null || this.textValue != null) {
            return this.getTextFromProperPlace();
        }
        try {
            return Base64Utils.encode((DataHandler)((DataHandler)this.getDataHandler()));
        }
        catch (Exception e) {
            throw new OMException((Throwable)e);
        }
    }

    public String getData() throws DOMException {
        return this.getText();
    }

    public char[] getTextCharacters() {
        return this.charArray != null ? this.charArray : this.textValue.toString().toCharArray();
    }

    public boolean isCharacters() {
        return this.charArray != null;
    }

    private String getTextFromProperPlace() {
        return this.charArray != null ? new String(this.charArray) : this.textValue.toString();
    }

    private String getTextString() {
        if (this.textNS != null) {
            String prefix = this.textNS.getPrefix();
            if (prefix == null || "".equals(prefix)) {
                return this.getTextFromProperPlace();
            }
            return prefix + ":" + this.getTextFromProperPlace();
        }
        return null;
    }

    public QName getTextAsQName() {
        if (this.textNS != null) {
            String prefix = this.textNS.getPrefix();
            String name = this.textNS.getNamespaceURI();
            if (prefix == null || "".equals(prefix)) {
                return new QName(name, this.getTextFromProperPlace());
            }
            return new QName(this.textNS.getNamespaceURI(), this.getTextFromProperPlace(), prefix);
        }
        if (this.textValue != null || this.charArray != null) {
            return new QName(this.getTextFromProperPlace());
        }
        try {
            return new QName(Base64Utils.encode((DataHandler)((DataHandler)this.getDataHandler())));
        }
        catch (Exception e) {
            throw new OMException((Throwable)e);
        }
    }

    public String getNodeValue() throws DOMException {
        return this.getText();
    }

    public String getContentID() {
        if (this.contentID == null) {
            this.contentID = UIDGenerator.generateContentId();
        }
        return this.contentID;
    }

    public Object getDataHandler() {
        if ((this.textValue != null || this.charArray != null || this.textNS != null) & this.isBinary) {
            String text = this.textNS == null ? this.getTextFromProperPlace() : this.getTextString();
            return DataHandlerUtils.getDataHandlerFromText((String)text, (String)this.mimeType);
        }
        if (this.dataHandlerObject == null) {
            if (this.contentID == null) {
                throw new RuntimeException("ContentID is null");
            }
            this.dataHandlerObject = ((XOPBuilder)this.builder).getDataHandler(this.contentID);
        } else if (this.dataHandlerObject instanceof DataHandlerProvider) {
            try {
                this.dataHandlerObject = ((DataHandlerProvider)this.dataHandlerObject).getDataHandler();
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
        }
        return this.dataHandlerObject;
    }

    public InputStream getInputStream() throws OMException {
        if (this.isBinary) {
            InputStream inStream;
            if (this.dataHandlerObject == null) {
                this.getDataHandler();
            }
            DataHandler dataHandler = (DataHandler)this.dataHandlerObject;
            try {
                inStream = dataHandler.getDataSource().getInputStream();
            }
            catch (IOException e) {
                throw new OMException("Cannot get InputStream from DataHandler.", (Throwable)e);
            }
            return inStream;
        }
        throw new OMException("Unsupported Operation");
    }

    public void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (!this.isBinary) {
            this.writeOutput(writer);
        } else {
            try {
                XMLStreamWriterUtils.writeDataHandler((XMLStreamWriter)writer, (DataHandler)((DataHandler)this.getDataHandler()), (String)this.contentID, (boolean)this.optimize);
            }
            catch (IOException ex) {
                throw new OMException("Error reading data handler", (Throwable)ex);
            }
        }
    }

    public String getWholeText() {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isElementContentWhitespace() {
        throw new UnsupportedOperationException("TODO");
    }

    public Text replaceWholeText(String arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public String toString() {
        return this.textValue != null ? this.textValue.toString() : "";
    }

    public void buildWithAttachments() {
        this.build();
        if (this.isOptimized()) {
            this.getDataHandler();
        }
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public void setBinary(boolean value) {
        this.isBinary = value;
    }

    public OMNamespace getNamespace() {
        return this.textNS;
    }

    public void setContentID(String cid) {
        this.contentID = cid;
    }
}

