/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jettison.mapped;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.jettison.Convention;
import org.codehaus.jettison.Node;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.mapped.Configuration;

public class MappedNamespaceConvention
implements Convention {
    private Map xnsToJns = new HashMap();
    private Map jnsToXns = new HashMap();
    private List attributesAsElements;
    private List jsonAttributesAsElements;

    public MappedNamespaceConvention() {
    }

    public MappedNamespaceConvention(Configuration config) {
        this.xnsToJns = config.getXmlToJsonNamespaces();
        this.attributesAsElements = config.getAttributesAsElements();
        Iterator itr = this.xnsToJns.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            this.jnsToXns.put(entry.getValue(), entry.getKey());
        }
        this.jsonAttributesAsElements = new ArrayList();
        if (this.attributesAsElements != null) {
            itr = this.attributesAsElements.iterator();
            while (itr.hasNext()) {
                QName q = (QName)((Object)itr.next());
                this.jsonAttributesAsElements.add(this.createAttributeKey(q.getPrefix(), q.getNamespaceURI(), q.getLocalPart()));
            }
        }
    }

    public void processAttributesAndNamespaces(Node n, JSONObject object) throws JSONException {
        Iterator itr = object.keys();
        while (itr.hasNext()) {
            JSONArray array;
            String value;
            String k = (String)itr.next();
            if (k.startsWith("@")) {
                value = object.optString(k);
                k = k.substring(1);
                if (value != null) {
                    this.readAttribute(n, k, value);
                } else {
                    array = object.optJSONArray(k);
                    if (array != null) {
                        this.readAttribute(n, k, array);
                    }
                }
                itr.remove();
                continue;
            }
            if (this.jsonAttributesAsElements == null || !this.jsonAttributesAsElements.contains(k)) continue;
            value = object.optString(k);
            if (value != null) {
                this.readAttribute(n, k, value);
            } else {
                array = object.optJSONArray(k);
                if (array != null) {
                    this.readAttribute(n, k, array);
                }
            }
            itr.remove();
        }
    }

    public QName createQName(String rootName, Node node) {
        return this.createQName(rootName);
    }

    private void readAttribute(Node n, String k, JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            this.readAttribute(n, k, array.getString(i));
        }
    }

    private void readAttribute(Node n, String name, String value) throws JSONException {
        QName qname = this.createQName(name);
        n.getAttributes().put(qname, value);
    }

    private QName createQName(String name) {
        int dot = name.lastIndexOf(46);
        QName qname = null;
        if (dot != -1) {
            String jns = name.substring(0, dot);
            String xns = (String)this.jnsToXns.get(jns);
            if (xns == null) {
                qname = new QName(name);
            } else {
                String local = name.substring(dot + 1);
                qname = new QName(xns, local);
            }
        } else {
            qname = new QName(name);
        }
        return qname;
    }

    public String createAttributeKey(String p, String ns, String local) {
        StringBuffer builder = new StringBuffer().append('@');
        String jns = this.getJSONNamespace(ns);
        if (jns != null && jns.length() != 0) {
            builder.append(jns).append('.');
        }
        return builder.append(local).toString();
    }

    private String getJSONNamespace(String ns) {
        if (ns == null || ns.length() == 0) {
            return "";
        }
        String jns = (String)this.xnsToJns.get(ns);
        if (jns == null) {
            throw new IllegalStateException("Invalid JSON namespace: " + ns);
        }
        return jns;
    }

    public String createKey(String p, String ns, String local) {
        StringBuffer builder = new StringBuffer();
        String jns = this.getJSONNamespace(ns);
        if (jns != null && jns.length() != 0) {
            builder.append(jns).append('.');
        }
        return builder.append(local).toString();
    }

    public boolean isElement(String p, String ns, String local) {
        if (this.attributesAsElements == null) {
            return false;
        }
        Iterator itr = this.attributesAsElements.iterator();
        while (itr.hasNext()) {
            QName q = (QName)itr.next();
            if (!q.getNamespaceURI().equals(ns) || !q.getLocalPart().equals(local)) continue;
            return true;
        }
        return false;
    }
}

