/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Trunc
extends AbstractFunction {
    public Trunc() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "number", "Any number."), new ArgDescriptor(ArgType.OPT_FLOAT, "num_digits", "The number of digits after the decimal point.")});
    }

    public String getName() {
        return "TRUNC";
    }

    public String getFunctionSummary() {
        return "Truncates a number. (Rounds towards zero.)";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        long numDigits;
        double number;
        try {
            number = FunctionUtil.getArgAsDouble(args[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot convert \"" + args[0] + "\" to a number in a call to TRUNC()!");
        }
        double absNumber = Math.abs(number);
        if (args.length == 1) {
            numDigits = 0L;
        } else {
            try {
                numDigits = FunctionUtil.getArgAsLong(args[1]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("cannot convert \"" + args[1] + "\" to an integer in a call to TRUNC()!");
            }
        }
        double shift = Math.pow(10.0, numDigits);
        double truncatedAbsNumber = (double)Math.round(absNumber * shift - 0.5) / shift;
        return number > 0.0 ? truncatedAbsNumber : -truncatedAbsNumber;
    }
}

