/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

class OrderNSymbolList
extends AbstractSymbolList
implements Serializable {
    private final SymbolList source;
    private final Alphabet alpha;
    private final int order;

    public SymbolList getSource() {
        return this.source;
    }

    public OrderNSymbolList(SymbolList source, int order) throws IllegalAlphabetException {
        this.source = source;
        Alphabet a = source.getAlphabet();
        this.alpha = AlphabetManager.getCrossProductAlphabet(Collections.nCopies(order, a));
        this.order = order;
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public int length() {
        return this.source.length() - this.order + 1;
    }

    public Symbol symbolAt(int index) throws IndexOutOfBoundsException {
        if (index < 1 || index > this.length()) {
            throw new IndexOutOfBoundsException("index must be within (1 .. " + this.length() + "), not " + index);
        }
        try {
            Symbol[] syms = new Symbol[this.order];
            for (int i = 0; i < this.order; ++i) {
                syms[i] = this.source.symbolAt(index + i);
            }
            return this.alpha.getSymbol(Arrays.asList(syms));
        }
        catch (IllegalSymbolException iae) {
            throw new BioError("Alphabet changed underneath me", iae);
        }
    }
}

