/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.discrete;

import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import java.awt.Component;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;

public class ShapeCellRenderer
extends DefaultCellRenderer {
    private final Map<Object, Icon> icons;
    private VisualPropertyType type;

    public ShapeCellRenderer(VisualPropertyType type) {
        this.type = type;
        this.icons = type.getVisualProperty().getIconSet();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        if (value != null) {
            VisualPropertyIcon shapeIcon = (VisualPropertyIcon)this.icons.get(value);
            if (shapeIcon != null) {
                if (this.type.equals((Object)VisualPropertyType.EDGE_SRCARROW_SHAPE) || this.type.equals((Object)VisualPropertyType.EDGE_TGTARROW_SHAPE)) {
                    shapeIcon.setIconHeight(16);
                    shapeIcon.setIconWidth(40);
                    shapeIcon.setBottomPadding(-6);
                } else {
                    shapeIcon.setIconHeight(16);
                    shapeIcon.setIconWidth(16);
                }
                this.setIcon(shapeIcon);
            }
            this.setIconTextGap(10);
            this.setText(value.toString());
        } else {
            this.setIcon(null);
            this.setText(null);
        }
        return this;
    }
}

