/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.discrete;

import cytoscape.Cytoscape;
import cytoscape.visual.mappings.discrete.DiscreteMappingReader;
import cytoscape.visual.mappings.discrete.DiscreteMappingReaderTest;
import cytoscape.visual.mappings.discrete.DiscreteMappingWriter;
import cytoscape.visual.parsers.ColorParser;
import java.io.InputStream;
import java.util.Properties;
import java.util.SortedMap;
import junit.framework.TestCase;

public class DiscreteMappingWriterTest
extends TestCase {
    public void testWriter() throws Exception {
        String baseKey = "nodeColorCalculator.JUnitDiscreteColor.mapping";
        ColorParser parser = new ColorParser();
        InputStream in = DiscreteMappingReaderTest.getDataFile();
        Properties properties = new Properties();
        properties.load(in);
        DiscreteMappingReader reader = new DiscreteMappingReader(properties, baseKey, parser);
        SortedMap map = reader.getMap();
        DiscreteMappingWriter writer = new DiscreteMappingWriter(reader.getControllingAttributeName(), baseKey, reader.getMap());
        Properties newProps = writer.getProperties();
        String mapA = newProps.getProperty(baseKey + ".map.A");
        DiscreteMappingWriterTest.assertEquals("204,255,255", mapA);
        String mapY = newProps.getProperty(baseKey + ".map.Y");
        DiscreteMappingWriterTest.assertEquals("255,51,51", mapY);
        String type = newProps.getProperty(baseKey + ".controller");
        DiscreteMappingWriterTest.assertEquals("canonicalName", type);
    }

    public void testControllerTypeWriting() throws Exception {
        String baseKey = "nodeColorCalculator.JUnitDiscreteColor.mapping";
        ColorParser parser = new ColorParser();
        InputStream in = DiscreteMappingReaderTest.getControllerTypeDataFile();
        Properties properties = new Properties();
        properties.load(in);
        DiscreteMappingReader reader = new DiscreteMappingReader(properties, baseKey, parser);
        SortedMap map = reader.getMap();
        DiscreteMappingWriter writer = new DiscreteMappingWriter(reader.getControllingAttributeName(), baseKey, reader.getMap());
        Properties newProps = writer.getProperties();
        String mapA = newProps.getProperty(baseKey + ".map.1");
        DiscreteMappingWriterTest.assertEquals("204,255,255", mapA);
        String mapY = newProps.getProperty(baseKey + ".map.6");
        DiscreteMappingWriterTest.assertEquals("255,51,51", mapY);
        String type = newProps.getProperty(baseKey + ".controller");
        DiscreteMappingWriterTest.assertEquals("controller", "homer", type);
        String ctype = newProps.getProperty(baseKey + ".controllerType");
        DiscreteMappingWriterTest.assertEquals("controllerType", "-1", ctype);
    }

    public void testControllerTypeWritingWithAttr() throws Exception {
        String baseKey = "nodeColorCalculator.JUnitDiscreteColor.mapping";
        ColorParser parser = new ColorParser();
        InputStream in = DiscreteMappingReaderTest.getControllerTypeDataFile();
        Properties properties = new Properties();
        properties.load(in);
        Cytoscape.getNodeAttributes().setAttribute("id", "homer", 15);
        DiscreteMappingReader reader = new DiscreteMappingReader(properties, baseKey, parser);
        SortedMap map = reader.getMap();
        DiscreteMappingWriter writer = new DiscreteMappingWriter(reader.getControllingAttributeName(), baseKey, reader.getMap());
        Properties newProps = writer.getProperties();
        String mapA = newProps.getProperty(baseKey + ".map.1");
        DiscreteMappingWriterTest.assertEquals("204,255,255", mapA);
        String mapY = newProps.getProperty(baseKey + ".map.6");
        DiscreteMappingWriterTest.assertEquals("255,51,51", mapY);
        String type = newProps.getProperty(baseKey + ".controller");
        DiscreteMappingWriterTest.assertEquals("controller", "homer", type);
        String ctype = newProps.getProperty(baseKey + ".controllerType");
        DiscreteMappingWriterTest.assertEquals("controllerType", "3", ctype);
    }
}

