/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveImageTask
implements Callable<String> {
    private final File imageHome;
    private String fileName;
    private final BufferedImage image;

    public SaveImageTask(File imageHomeDirectory, String fileName, BufferedImage image) {
        this.imageHome = imageHomeDirectory;
        this.fileName = fileName;
        this.image = image;
    }

    @Override
    public String call() throws Exception {
        if (!this.fileName.endsWith(".png")) {
            this.fileName = this.fileName + ".png";
        }
        File file = new File(this.imageHome, this.fileName);
        try {
            file.createNewFile();
            ImageIO.write((RenderedImage)this.image, "PNG", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file.toString();
    }
}

