/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.VisualPropertyDependency;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;

class VisualPropertyDependencyImpl
implements VisualPropertyDependency {
    private final Map<VisualPropertyDependency.Definition, Boolean> state = new EnumMap<VisualPropertyDependency.Definition, Boolean>(VisualPropertyDependency.Definition.class);

    VisualPropertyDependencyImpl() {
    }

    public boolean check(VisualPropertyDependency.Definition s) {
        if (this.state.containsKey((Object)s)) {
            return this.state.get((Object)s);
        }
        return s.getDefault();
    }

    public void set(VisualPropertyDependency.Definition s, boolean b) {
        if (s != null) {
            this.state.put(s, b);
        }
    }

    public void applyDefaultProperties(Properties props, String baseKey) {
        for (VisualPropertyDependency.Definition d : VisualPropertyDependency.Definition.values()) {
            String lockKey = baseKey + "." + d.getDefaultPropertyKey();
            String lockVal = props.getProperty(lockKey);
            if (lockVal == null) continue;
            if (lockVal.equalsIgnoreCase("true")) {
                this.set(d, true);
                continue;
            }
            if (!lockVal.equalsIgnoreCase("false")) continue;
            this.set(d, false);
        }
    }

    public Properties getDefaultProperties(String baseKey) {
        Properties props = new Properties();
        for (VisualPropertyDependency.Definition d : this.state.keySet()) {
            String lockKey = baseKey + "." + d.getDefaultPropertyKey();
            props.setProperty(lockKey, Boolean.valueOf(this.check(d)).toString());
        }
        return props;
    }

    public void copy(VisualPropertyDependency d) {
        if (this == d) {
            return;
        }
        this.state.clear();
        for (VisualPropertyDependency.Definition def : VisualPropertyDependency.Definition.values()) {
            boolean b = d.check(def);
            if (b == def.getDefault()) continue;
            this.state.put(def, b);
        }
    }

    public String toString() {
        String ret = "dependency state (" + this.hashCode() + "): ";
        for (VisualPropertyDependency.Definition d : this.state.keySet()) {
            ret = ret + "  [" + (Object)((Object)d) + " " + this.state.get((Object)d) + "]";
        }
        return ret;
    }
}

