/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.swing;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class NetworkSelectorPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 8694272457769377810L;
    protected final JComboBox networkComboBox;

    public NetworkSelectorPanel() {
        this.setLayout(new BorderLayout());
        this.networkComboBox = new JComboBox();
        this.networkComboBox.setPreferredSize(new Dimension(this.networkComboBox.getPreferredSize().width, this.networkComboBox.getPreferredSize().height));
        this.add((Component)this.networkComboBox, "Center");
        this.updateNetworkList();
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public CyNetwork getSelectedNetwork() {
        for (CyNetwork net : Cytoscape.getNetworkSet()) {
            if (!net.getTitle().equals(this.networkComboBox.getSelectedItem())) continue;
            return net;
        }
        return null;
    }

    private void updateNetworkList() {
        Set<CyNetwork> networks = Cytoscape.getNetworkSet();
        TreeSet<String> networkNames = new TreeSet<String>();
        for (CyNetwork net : networks) {
            networkNames.add(net.getTitle());
        }
        this.networkComboBox.removeAllItems();
        for (String name : networkNames) {
            this.networkComboBox.addItem(name);
        }
        this.networkComboBox.setSelectedItem(Cytoscape.getCurrentNetwork().getTitle());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equals(Cytoscape.NETWORK_CREATED) || propName.equals("NETWORK_TITLE_MODIFIED")) {
            this.updateNetworkList();
        } else if (propName.equals(Cytoscape.NETWORK_DESTROYED)) {
            this.networkComboBox.removeItem(Cytoscape.getNetwork((String)evt.getNewValue()).getTitle());
        }
    }

    public void addItemListener(ItemListener newListener) {
        this.networkComboBox.addItemListener(newListener);
    }
}

