/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.intr.test;

import cytoscape.util.intr.IntBTree;
import java.io.IOException;
import java.io.InputStream;

public class IntBTreeConstructionTuner {
    public static void main(String[] args) throws IOException {
        int i;
        int read;
        int branches = Integer.parseInt(args[0]);
        int N = Integer.parseInt(args[1]);
        int[] elements = new int[N];
        InputStream in = System.in;
        byte[] buff = new byte[4];
        int inx = 0;
        int off = 0;
        while (inx < N && (read = in.read(buff, off, buff.length - off)) > 0) {
            if ((off += read) < buff.length) continue;
            off = 0;
            elements[inx++] = (Integer.MAX_VALUE & IntBTreeConstructionTuner.assembleInt(buff)) % N;
        }
        if (inx < N) {
            throw new IOException("premature end of input");
        }
        IntBTree tree = new IntBTree(branches);
        long timeBegin = System.currentTimeMillis();
        tree.insert(elements[0]);
        for (i = 1; i < elements.length; ++i) {
            tree.delete(elements[i - 1]);
            tree.insert(elements[i]);
            tree.insert(elements[i - 1]);
            tree.insert(elements[i]);
            tree.delete(elements[i]);
        }
        if (tree.size() != elements.length) {
            throw new IllegalStateException();
        }
        tree.delete(elements[0]);
        for (i = 1; i < elements.length; ++i) {
            tree.delete(elements[i]);
            tree.insert(elements[i - 1]);
            tree.insert(elements[i]);
            tree.delete(elements[i - 1]);
            tree.delete(elements[i]);
        }
        if (tree.size() != 0) {
            throw new IllegalStateException();
        }
        long timeEnd = System.currentTimeMillis();
        System.out.println(timeEnd - timeBegin + " milliseconds");
    }

    private static int assembleInt(byte[] fourConsecutiveBytes) {
        int firstByte = (fourConsecutiveBytes[0] & 0xFF) << 24;
        int secondByte = (fourConsecutiveBytes[1] & 0xFF) << 16;
        int thirdByte = (fourConsecutiveBytes[2] & 0xFF) << 8;
        int fourthByte = (fourConsecutiveBytes[3] & 0xFF) << 0;
        return firstByte | secondByte | thirdByte | fourthByte;
    }
}

