/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.intr;

import cytoscape.util.intr.IntEnumerator;
import java.io.Serializable;

public final class IntStack
implements Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private int[] m_stack = new int[11];
    private int m_currentSize;

    public IntStack() {
        this.empty();
    }

    public final void empty() {
        this.m_currentSize = 0;
    }

    public final int size() {
        return this.m_currentSize;
    }

    public final void push(int value) {
        try {
            this.m_stack[this.m_currentSize++] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            --this.m_currentSize;
            this.checkSize();
            this.m_stack[this.m_currentSize++] = value;
        }
    }

    public final int peek() {
        return this.m_stack[this.m_currentSize - 1];
    }

    public final int pop() {
        try {
            return this.m_stack[--this.m_currentSize];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ++this.m_currentSize;
            throw e;
        }
    }

    public final IntEnumerator elements() {
        final int[] stack = this.m_stack;
        final int size = this.m_currentSize;
        return new IntEnumerator(){
            private int inx;
            {
                this.inx = size;
            }

            public final int numRemaining() {
                return this.inx;
            }

            public final int nextInt() {
                return stack[--this.inx];
            }
        };
    }

    private final void checkSize() {
        if (this.m_currentSize < this.m_stack.length) {
            return;
        }
        int newStackSize = (int)Math.min(Integer.MAX_VALUE, (long)this.m_stack.length * 2L + 1L);
        if (newStackSize == this.m_stack.length) {
            throw new IllegalStateException("cannot allocate large enough array");
        }
        int[] newStack = new int[newStackSize];
        System.arraycopy(this.m_stack, 0, newStack, 0, this.m_stack.length);
        this.m_stack = newStack;
    }
}

