/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.export;

import cytoscape.Cytoscape;
import cytoscape.util.export.Exporter;
import cytoscape.view.CyNetworkView;
import cytoscape.view.InternalFrameComponent;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class BitmapExporter
implements Exporter {
    private String extension;
    private double scale;

    public BitmapExporter(String extension, double scale) {
        this.extension = extension;
        this.scale = scale;
        boolean match = false;
        String[] formats = ImageIO.getWriterFormatNames();
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].equals(extension)) continue;
            match = true;
            break;
        }
        if (!match) {
            throw new IllegalArgumentException("Format " + extension + " is not supported by the ImageIO class");
        }
    }

    public void export(CyNetworkView view, FileOutputStream stream) throws IOException {
        InternalFrameComponent ifc = Cytoscape.getDesktop().getNetworkViewManager().getInternalFrameComponent(view);
        int width = (int)((double)ifc.getWidth() * this.scale);
        int height = (int)((double)ifc.getHeight() * this.scale);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.scale(this.scale, this.scale);
        ifc.print(g);
        g.dispose();
        ImageIO.write((RenderedImage)image, this.extension, stream);
    }
}

