/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.data.ImportHandler;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.XGMMLReader;
import cytoscape.logger.CyLogger;
import cytoscape.util.CyFileFilter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public class XGMMLFileFilter
extends CyFileFilter {
    private static String fileNature = ImportHandler.GRAPH_NATURE;
    private static String[] fileExtensions = new String[]{"xgmml", "xml"};
    private static String[] xgmmlContentTypes = new String[]{"text/xgmml", "text/xgmml+xml"};
    private static String description = "XGMML files";

    public XGMMLFileFilter() {
        super(fileExtensions, description, fileNature);
        for (int i = 0; i < xgmmlContentTypes.length; ++i) {
            this.addContentType(xgmmlContentTypes[i]);
        }
    }

    public GraphReader getReader(String fileName) {
        this.reader = new XGMMLReader(fileName);
        return this.reader;
    }

    public GraphReader getReader(URL url, URLConnection conn) {
        try {
            this.reader = new XGMMLReader(conn.getInputStream(), url.toString());
        }
        catch (Exception e) {
            CyLogger.getLogger(XGMMLFileFilter.class).error("Unable to get XGMML reader: " + e.getMessage());
            this.reader = null;
        }
        return this.reader;
    }

    public boolean accept(File file) {
        String fileName = file.getName();
        boolean firstPass = false;
        for (int i = 0; i < fileExtensions.length; ++i) {
            if (!fileName.endsWith(fileExtensions[i])) continue;
            firstPass = true;
        }
        if (firstPass) {
            try {
                String header = this.getHeader(file).toLowerCase();
                if (header.indexOf("www.cs.rpi.edu/xgmml") > 0) {
                    return true;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean accept(URL url, String contentType) {
        if (contentType != null && this.contentTypes != null && this.contentTypes.get(contentType) != null) {
            return true;
        }
        try {
            String header = this.getHeader(url).toLowerCase();
            if (header.indexOf("www.cs.rpi.edu/xgmml") > 0) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }
}

