/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

class QuantileNorm {
    QuantileNorm() {
    }

    public static float[] quantileNorm(float[] v) {
        float[] rank = QuantileNorm.rankWTies(v);
        return QuantileNorm.divideBy(QuantileNorm.subtract(rank, 0.5f), v.length);
    }

    private static int[] sort_I(float[] v) {
        return QuantileNorm.Sort_I(QuantileNorm.copy(v));
    }

    private static float[] rankWTies(float[] v) {
        int[] order = QuantileNorm.sort_I(v);
        float[] out = new float[order.length];
        for (int i = 0; i < order.length; ++i) {
            int j;
            for (j = i + 1; j < order.length && v[order[i]] == v[order[j]]; ++j) {
            }
            if (i == --j) {
                out[order[i]] = i + 1;
            } else {
                long rsum = 0L;
                for (int k = i; k <= j; ++k) {
                    rsum += (long)(k + 1);
                }
                float r = (float)rsum / (float)(j - i + 1);
                for (int k = i; k <= j; ++k) {
                    out[order[k]] = r;
                }
            }
            i = j;
        }
        return out;
    }

    private static float[] divideBy(float[] v, int val) {
        float[] out = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            out[i] = v[i] / (float)val;
        }
        return out;
    }

    private static float[] subtract(float[] v, float val) {
        float[] out = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            out[i] = v[i] - val;
        }
        return out;
    }

    public static float[] copy(float[] vec) {
        float[] out = new float[vec.length];
        for (int i = 0; i < vec.length; ++i) {
            out[i] = vec[i];
        }
        return out;
    }

    public static int[] Sort_I(float[] dv) {
        int[] index = new int[dv.length];
        for (int i = 0; i < dv.length; ++i) {
            index[i] = i;
        }
        QuantileNorm.sortwI(dv, 0, dv.length, index);
        return index;
    }

    private static void sortwI(float[] x, int off, int len, int[] index) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    QuantileNorm.swap(x, j, j - 1, index);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = QuantileNorm.med3(x, l, l + s, l + 2 * s);
                m = QuantileNorm.med3(x, m - s, m, m + s);
                n = QuantileNorm.med3(x, n - 2 * s, n - s, n);
            }
            m = QuantileNorm.med3(x, l, m, n);
        }
        float v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    QuantileNorm.swap(x, a++, b, index);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    QuantileNorm.swap(x, c, d--, index);
                }
                --c;
            }
            if (b > c) break;
            QuantileNorm.swap(x, b++, c--, index);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        QuantileNorm.vecswap(x, off, b - s, s, index);
        s = Math.min(d - c, n - d - 1);
        QuantileNorm.vecswap(x, b, n - s, s, index);
        s = b - a;
        if (s > 1) {
            QuantileNorm.sortwI(x, off, s, index);
        }
        if ((s = d - c) > 1) {
            QuantileNorm.sortwI(x, n - s, s, index);
        }
    }

    private static void swap(float[] x, int a, int b, int[] index) {
        float t = x[a];
        x[a] = x[b];
        x[b] = t;
        int ti = index[a];
        index[a] = index[b];
        index[b] = ti;
    }

    private static void vecswap(float[] x, int a, int b, int n, int[] index) {
        int i = 0;
        while (i < n) {
            QuantileNorm.swap(x, a, b, index);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(float[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }
}

