/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.task.sample;

import cytoscape.task.sample.SampleTask;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RunSampleTask {
    public static void main(String[] args) {
        JFrame frame = RunSampleTask.createJFrame();
        System.out.println("Running Task Demo");
        System.out.println("Press CTRL-C to end...");
        int option = 0;
        SampleTask task = null;
        if (args.length != 0) {
            option = Integer.parseInt(args[0]);
        }
        task = option != 2 ? new SampleTask(100, 100L) : new SampleTask(100, 100L, 10);
        JTaskConfig config = new JTaskConfig();
        if (option == 1) {
            config.setMillisToPopup(2000);
        }
        config.setOwner(frame);
        RunSampleTask.configureJTask(option, config);
        boolean success = TaskManager.executeTask(task, config);
        if (success) {
            System.out.println("Task completed successfully");
        } else {
            System.out.println("Task aborted due to user request or task error.");
        }
    }

    private static JFrame createJFrame() {
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        JLabel label = new JLabel("A Dummy Cytoscape Desktop");
        panel.add(label);
        frame.getContentPane().add(panel);
        frame.setSize(400, 400);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        return frame;
    }

    private static void configureJTask(int option, JTaskConfig config) {
        switch (option) {
            case 0: {
                System.out.println("This demo illustrates a Bare Bones JTask PopUp.");
                System.out.println("--  Description and progress are displayed");
                System.out.println("--  Task cannot be cancelled.");
                break;
            }
            case 1: {
                config.displayStatus(true);
                config.displayTimeElapsed(true);
                config.displayTimeRemaining(true);
                config.displayCancelButton(true);
                config.displayCloseButton(true);
                config.setAutoDispose(false);
                System.out.println("This demo illustrates a customized JTask PopUp.");
                System.out.println("-- All time fields are displayed.");
                System.out.println("-- Description Field is displayed.");
                System.out.println("-- Status Field is displayed.");
                System.out.println("-- Task can be cancelled");
                System.out.println("-- Dialog box popups up after delay");
                break;
            }
            case 2: {
                config.displayCancelButton(true);
                config.displayCloseButton(true);
                System.out.println("This demo illustrates exception handling.");
                System.out.println("--  This task will end prematurely with an error.");
                System.out.println("--  This task can be canceled");
            }
        }
    }
}

