/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.render.stateful;

import cytoscape.render.stateful.PaintFactory;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class CustomGraphic {
    private final Shape shape;
    private PaintFactory pf;
    private Paint paint;
    @Deprecated
    private final byte anchor;

    public CustomGraphic(Shape shape, PaintFactory factory) {
        if (shape == null) {
            throw new IllegalArgumentException("The shape given was null.");
        }
        this.shape = shape;
        this.anchor = 0;
        this.pf = factory;
    }

    @Deprecated
    public CustomGraphic(Shape shape, Paint paint, byte anchor) {
        this(shape, null);
        if (anchor < 0 || anchor > 8) {
            throw new IllegalArgumentException("The anchor value " + anchor + " is not in the range 0 <= anchor <= " + 8 + ".");
        }
        this.paint = paint;
        this.pf = new DefaultPaintFactory(this.paint);
    }

    public Shape getShape() {
        return this.shape;
    }

    public Paint getPaint() {
        if (this.paint != null) {
            return this.paint;
        }
        return this.getPaint(this.shape.getBounds2D());
    }

    public Paint getPaint(Rectangle2D bound) {
        this.paint = this.pf.getPaint(bound);
        return this.paint;
    }

    public PaintFactory getPaintFactory() {
        return this.pf;
    }

    @Deprecated
    public byte getAnchor() {
        return this.anchor;
    }

    private class DefaultPaintFactory
    implements PaintFactory {
        private final Paint p;

        public DefaultPaintFactory(Paint p) {
            this.p = p;
        }

        public Paint getPaint(Rectangle2D bound) {
            return this.p;
        }
    }
}

