/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.webservice.ui;

import cytoscape.data.webservice.WebServiceClient;
import cytoscape.data.webservice.WebServiceClientManager;
import cytoscape.data.webservice.ui.WebServiceClientGUI;
import ding.view.EdgeContextMenuListener;
import ding.view.NodeContextMenuListener;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class WebServiceContextMenu
implements NodeContextMenuListener,
EdgeContextMenuListener {
    private HashMap<String, String> clientMap = new HashMap();
    private JMenu nodeRootMenu = new JMenu("Use Web Services");
    private JMenu edgeRootMenu = new JMenu("Use Web Services");

    public void addNodeContextMenuItems(NodeView nodeView, JPopupMenu menu) {
        this.addMenu(nodeView, menu);
    }

    public void addEdgeContextMenuItems(EdgeView edgeView, JPopupMenu menu) {
        this.addMenu(edgeView, menu);
    }

    private void addMenu(Object view, JPopupMenu menu) {
        if (menu == null) {
            menu = new JPopupMenu();
        } else {
            this.nodeRootMenu.removeAll();
            this.edgeRootMenu.removeAll();
        }
        List<JMenuItem> context = null;
        List<WebServiceClient<?>> clients = WebServiceClientManager.getAllClients();
        for (WebServiceClient<?> client : clients) {
            if (!(client instanceof WebServiceClientGUI)) continue;
            if (view instanceof NodeView) {
                context = ((WebServiceClientGUI)((Object)client)).getNodeContextMenuItems((NodeView)view);
            } else if (view instanceof EdgeView) {
                context = ((WebServiceClientGUI)((Object)client)).getEdgeContextMenuItems((EdgeView)view);
            }
            if (context == null) continue;
            JMenu cMenu = new JMenu(client.getDisplayName());
            for (JMenuItem menuItem : context) {
                cMenu.add(menuItem);
            }
            this.nodeRootMenu.add(cMenu);
            this.clientMap.put(client.getDisplayName(), client.getClientID());
        }
        if (view instanceof NodeView) {
            menu.add(this.nodeRootMenu);
            if (this.nodeRootMenu.getItemCount() == 0) {
                this.nodeRootMenu.setEnabled(false);
            }
        } else {
            menu.add(this.edgeRootMenu);
            if (this.edgeRootMenu.getItemCount() == 0) {
                this.edgeRootMenu.setEnabled(false);
            }
        }
    }
}

