/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.logger.CyLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class TextFileReader {
    String filename;
    StringBuffer strbuf;
    CyLogger logger = CyLogger.getLogger(TextFileReader.class);

    public TextFileReader(String filename) {
        this.filename = filename;
        this.strbuf = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() {
        BufferedReader bufferedReader = null;
        this.strbuf = new StringBuffer();
        int rv = -1;
        bufferedReader = new BufferedReader(new FileReader(this.filename));
        try {
            String newLineOfText;
            while ((newLineOfText = bufferedReader.readLine()) != null) {
                this.strbuf.append(newLineOfText + "\n");
            }
            rv = this.strbuf.length();
        }
        catch (IOException e) {
            this.logger.warn("IO error reading from text file: " + e.getMessage(), e);
        }
        Object var6_6 = null;
        if (bufferedReader == null) return rv;
        try {
            bufferedReader.close();
            return rv;
        }
        catch (IOException e2) {
            this.logger.warn("Unable to close text file '" + this.filename + "': " + e2.getMessage(), e2);
        }
        return rv;
        {
            catch (IOException e) {
                this.logger.warn("Unable to open text file '" + this.filename + "': " + e.getMessage(), e);
                Object var6_7 = null;
                if (bufferedReader == null) return rv;
                try {
                    bufferedReader.close();
                    return rv;
                }
                catch (IOException e2) {
                    this.logger.warn("Unable to close text file '" + this.filename + "': " + e2.getMessage(), e2);
                }
                return rv;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException e2) {
                this.logger.warn("Unable to close text file '" + this.filename + "': " + e2.getMessage(), e2);
            }
            throw throwable;
        }
    }

    public String getText() {
        return new String(this.strbuf);
    }

    public static void main(String[] argv) {
        int argCount = argv.length;
        String fileToRead = argCount == 0 ? "TextFileReader.java" : argv[0];
        TextFileReader reader = new TextFileReader(fileToRead);
        int size = reader.read();
        System.out.println("size of text block: " + size);
        System.out.println(reader.getText());
    }
}

