/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NNFParser {
    private String[] parts;
    private int length;
    private final List<CyNetwork> networks;
    private Map<String, CyNetwork> networkMap = new HashMap<String, CyNetwork>();

    public NNFParser() {
        this.networks = new ArrayList<CyNetwork>();
    }

    private CyNetwork getNetworkByTitle(String networkTitle) {
        Set<CyNetwork> networks = Cytoscape.getNetworkSet();
        for (CyNetwork network : networks) {
            if (!network.getTitle().equals(networkTitle)) continue;
            return network;
        }
        return null;
    }

    public boolean parse(String line) {
        this.parts = line.split("\\s+");
        this.length = this.parts.length;
        CyNetwork network = this.networkMap.get(this.parts[0]);
        if (network == null) {
            network = this.getNetworkByTitle(this.parts[0]);
            if (network == null) {
                network = Cytoscape.createNetwork(this.parts[0], false);
            }
            this.networkMap.put(this.parts[0], network);
            this.networks.add(network);
            CyNode parent = Cytoscape.getCyNode(this.parts[0]);
            if (parent != null) {
                parent.setNestedNetwork(network);
            }
        }
        if (this.length == 2) {
            CyNode node = Cytoscape.getCyNode(this.parts[1], true);
            network.addNode(node);
            CyNetwork nestedNetwork = this.networkMap.get(this.parts[1]);
            if (nestedNetwork != null) {
                node.setNestedNetwork(nestedNetwork);
            }
        } else if (this.length == 4) {
            CyNode source = Cytoscape.getCyNode(this.parts[1], true);
            network.addNode(source);
            CyNetwork nestedNetwork = this.networkMap.get(this.parts[1]);
            if (nestedNetwork != null) {
                source.setNestedNetwork(nestedNetwork);
            }
            CyNode target = Cytoscape.getCyNode(this.parts[3], true);
            network.addNode(target);
            nestedNetwork = this.networkMap.get(this.parts[3]);
            if (nestedNetwork != null) {
                target.setNestedNetwork(nestedNetwork);
            }
            CyEdge edge = Cytoscape.getCyEdge(source, target, "interaction", this.parts[2], true, true);
            network.addEdge(edge);
        } else {
            return false;
        }
        return true;
    }

    protected List<CyNetwork> getNetworks() {
        return this.networks;
    }
}

