/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.data.CyAttributes;
import cytoscape.data.ontology.Ontology;
import cytoscape.data.readers.EqnAttrTracker;
import cytoscape.data.readers.XGMMLReader;
import cytoscape.generated.Child;
import cytoscape.generated.Cysession;
import cytoscape.generated.Edge;
import cytoscape.generated.HiddenEdges;
import cytoscape.generated.HiddenNodes;
import cytoscape.generated.Network;
import cytoscape.generated.NetworkFrame;
import cytoscape.generated.Node;
import cytoscape.generated.SelectedEdges;
import cytoscape.generated.SelectedNodes;
import cytoscape.logger.CyLogger;
import cytoscape.task.TaskMonitor;
import cytoscape.util.RecentlyOpenedTracker;
import cytoscape.util.URLUtil;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.DuplicateCalculatorNameException;
import cytoscape.visual.customgraphic.CustomGraphicsManager;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.customgraphic.IDGenerator;
import cytoscape.visual.customgraphic.Taggable;
import cytoscape.visual.customgraphic.impl.bitmap.URLImageCustomGraphics;
import cytoscape.visual.parsers.GraphicsParser;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JInternalFrame;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CytoscapeSessionReader {
    public static final String PACKAGE_NAME = "cytoscape.generated";
    public static final String BOOKMARK_PACKAGE_NAME = "cytoscape.bookmarks";
    public static final String CYSESSION = "cysession.xml";
    public static final String VIZMAP_PROPS = "vizmap.props";
    public static final String CY_PROPS = "cytoscape.props";
    public static final String XGMML_EXT = ".xgmml";
    private static final String BOOKMARKS_FILE = "session_bookmarks.xml";
    private static final String NETWORK_ROOT = "Network Root";
    private URL sourceURL;
    private Map networkURLs = null;
    private URL cysessionFileURL = null;
    private URL vizmapFileURL = null;
    private URL cytoscapePropsURL = null;
    private URL bookmarksFileURL = null;
    private HashMap<String, Network> netMap;
    private String sessionID;
    private Cysession session;
    private List networkList;
    private Bookmarks bookmarks = null;
    private HashMap<String, List<File>> pluginFileListMap;
    private HashMap<String, List<String>> theURLstrMap = new HashMap();
    private Map<String, URL> imageMap;
    private URL imagePropsURL;
    private TaskMonitor taskMonitor = null;
    private float networkCounter = 0.0f;
    private float netIndex = 0.0f;
    private long start;
    private String lastVSName = null;
    private CyLogger logger = null;
    private final GraphicsParser parser = new GraphicsParser();

    public CytoscapeSessionReader(URL sourceName, TaskMonitor monitor) throws IOException {
        this.sourceURL = sourceName;
        this.sourceURL = sourceName.getProtocol().equals("file") ? sourceName : this.temporaryLocalFileURL(sourceName);
        this.networkList = new ArrayList();
        this.bookmarks = new Bookmarks();
        this.pluginFileListMap = new HashMap();
        this.imageMap = new HashMap<String, URL>();
        this.taskMonitor = monitor;
        this.logger = CyLogger.getLogger(CytoscapeSessionReader.class);
        RecentlyOpenedTracker sessionTracker = Cytoscape.getRecentlyOpenedSessionTracker();
        if (sessionTracker != null) {
            sessionTracker.add(sourceName);
        }
    }

    public CytoscapeSessionReader(String fileName, TaskMonitor monitor) throws IOException {
        this(new File(fileName.replace("%", "%25")).toURL(), monitor);
    }

    public CytoscapeSessionReader(String fileName) throws IOException {
        this(new File(fileName.replace("%", "%25")).toURL(), (TaskMonitor)null);
    }

    public CytoscapeSessionReader(URL sourceName) throws IOException {
        this(sourceName, (TaskMonitor)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractEntry() throws IOException {
        URLConnection juc = this.sourceURL.openConnection();
        juc.setDefaultUseCaches(false);
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(juc.getInputStream());
            this.networkURLs = new HashMap();
            ZipEntry zen = null;
            String entryName = null;
            while ((zen = zis.getNextEntry()) != null) {
                entryName = zen.getName();
                if (entryName.contains("/plugins/")) {
                    this.extractPluginEntry(entryName);
                    continue;
                }
                if (entryName.endsWith(CYSESSION)) {
                    this.cysessionFileURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                    continue;
                }
                if (entryName.endsWith(VIZMAP_PROPS)) {
                    this.vizmapFileURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                    continue;
                }
                if (entryName.endsWith(CY_PROPS)) {
                    this.cytoscapePropsURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                    continue;
                }
                if (entryName.endsWith(XGMML_EXT)) {
                    String entryDir = "";
                    String entryRest = entryName;
                    int sp = entryName.indexOf("/");
                    if (sp != -1) {
                        entryDir = entryRest.substring(0, sp + 1);
                        entryRest = entryRest.substring(sp + 1);
                    }
                    URL networkURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryDir + URLEncoder.encode(entryRest, "UTF-8").replace("+", "%20"));
                    this.networkURLs.put(entryName, networkURL);
                    this.networkCounter += 1.0f;
                    continue;
                }
                if (entryName.endsWith(BOOKMARKS_FILE)) {
                    this.bookmarksFileURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                    continue;
                }
                if (entryName.endsWith(".png")) {
                    URL imageURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                    this.loadBitmapImageFiles(entryName, imageURL);
                    continue;
                }
                if (entryName.endsWith("image_metadata.props")) {
                    this.imagePropsURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                    continue;
                }
                this.logger.warn("Unknown entry found in session zip file: " + entryName);
            }
            Object var10_10 = null;
            if (zis == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (zis == null) throw throwable;
            zis.close();
            throw throwable;
        }
        zis.close();
    }

    private void extractPluginEntry(String entryName) {
        String[] items = entryName.split("/");
        if (items.length < 3) {
            return;
        }
        String pluginName = items[2];
        String URLstr = "jar:" + this.sourceURL.toString() + "!/" + entryName;
        if (this.theURLstrMap.containsKey(pluginName)) {
            List<String> theURLstrList = this.theURLstrMap.get(pluginName);
            theURLstrList.add(URLstr);
        } else {
            ArrayList<String> theURLstrList = new ArrayList<String>();
            theURLstrList.add(URLstr);
            this.theURLstrMap.put(pluginName, theURLstrList);
        }
    }

    private void loadBitmapImageFiles(String entryName, URL imageFileURL) throws IOException {
        String[] ent = entryName.split(System.getProperty("file.separator"));
        String displayName = ent[ent.length - 1];
        String name = displayName.split("\\.")[0];
        this.imageMap.put(name, imageFileURL);
    }

    private void restoreCustomGraphics() throws IOException {
        Properties imageProps = new Properties();
        imageProps.load(URLUtil.getBasicInputStream(this.imagePropsURL));
        CustomGraphicsManager manager = Cytoscape.getVisualMappingManager().getCustomGraphicsManager();
        manager.removeAll();
        for (String id : this.imageMap.keySet()) {
            URLImageCustomGraphics graphics = new URLImageCustomGraphics(Long.parseLong(id), this.imageMap.get(id).toString());
            String propEntry = imageProps.getProperty(id);
            if (propEntry == null) continue;
            imageProps.remove(id);
            String[] parts = propEntry.split(",");
            if (parts.length < 3) continue;
            String name = parts[parts.length - 2];
            if (name.contains("___")) {
                name = name.replace("___", ",");
            }
            graphics.setDisplayName(name);
            String tagStr = null;
            if (parts.length > 3 && graphics instanceof Taggable) {
                String[] tagParts;
                tagStr = parts[3];
                TreeSet<String> tags = new TreeSet<String>();
                for (String tag : tagParts = tagStr.split("\\|")) {
                    tags.add(tag.trim());
                }
                ((Taggable)graphics).getTags().addAll(tags);
            }
            try {
                URL nameAsURL = new URL(name);
                CyCustomGraphics currentValue = manager.getBySourceURL(nameAsURL);
                if (currentValue != null) continue;
                manager.addGraphics(graphics, nameAsURL);
            }
            catch (MalformedURLException e) {
                manager.addGraphics(graphics, null);
            }
        }
        System.out.println("Need to restore non-image graphics: " + imageProps.size());
        this.restoreNonImageGraphics(imageProps, manager);
        Long currentMax = manager.getIDSet().last();
        IDGenerator.getIDGenerator().initCounter(currentMax + 1L);
    }

    private void restoreNonImageGraphics(Properties imageProps, CustomGraphicsManager manager) {
        for (Object key : imageProps.keySet()) {
            String value = imageProps.getProperty(key.toString());
            System.out.println("Key = " + key + ", val = " + value);
            CyCustomGraphics cg = this.parser.parseStringValue(imageProps.getProperty(key.toString()));
            System.out.println("CG result = " + cg);
            if (cg == null) continue;
            manager.addGraphics(cg, null);
        }
    }

    public void read() throws IOException, JAXBException, Exception {
        this.start = System.currentTimeMillis();
        Cytoscape.firePropertyChange(Integer.toString(Cytoscape.SESSION_OPENED), null, true);
        Cytoscape.getDesktop().getVizMapperUI().initializeTableState();
        try {
            EqnAttrTracker eqnAttrTracker = Cytoscape.getEqnAttrTracker();
            eqnAttrTracker.reset();
            this.unzipSessionFromURL(true);
            eqnAttrTracker.addAllEquations();
        }
        catch (DuplicateCalculatorNameException dcne) {
            this.logger.warn("Duplicate VS name found.  It will be ignored...", dcne);
        }
        if (this.session.getSessionState().getDesktop() != null) {
            this.restoreDesktopState();
        }
        if (this.session.getSessionState().getServer() != null) {
            this.restoreOntologyServerStatus();
        }
        Cytoscape.firePropertyChange(Cytoscape.ATTRIBUTES_CHANGED, null, null);
        Cytoscape.firePropertyChange("NETWORK_LOADED", null, null);
        Cytoscape.firePropertyChange("RESTORE_PLUGIN_STATE", this.pluginFileListMap, null);
        this.deleteTmpPluginFiles();
        Cytoscape.firePropertyChange(Cytoscape.SESSION_LOADED, null, this.networkList);
        if (Cytoscape.getDesktop() != null) {
            CyNetworkView curView = Cytoscape.getCurrentNetworkView();
            if (curView != null && !curView.equals(Cytoscape.getNullNetworkView())) {
                curView.setVisualStyle(this.lastVSName);
                Cytoscape.getVisualMappingManager().setNetworkView(curView);
                Cytoscape.getVisualMappingManager().setVisualStyle(curView.getVisualStyle());
            }
            Cytoscape.getDesktop().getVizMapperUI().enableListeners(true);
        }
        this.logger.info("Session loaded in " + (System.currentTimeMillis() - this.start) + " msec.");
    }

    private void restoreNestedNetworkLinks() {
        CyAttributes nodeAttr = Cytoscape.getNodeAttributes();
        List<String> attrNames = Arrays.asList(nodeAttr.getAttributeNames());
        if (!attrNames.contains("nested_network_id")) {
            return;
        }
        Map<String, String> titleToIdMap = this.createNetworkTitleToIDMap();
        for (CyNetwork network : Cytoscape.getNetworkSet()) {
            for (CyNode node : network.nodesList()) {
                String nestedNetworkTitle = nodeAttr.getStringAttribute(node.getIdentifier(), "nested_network_id");
                if (nestedNetworkTitle == null) continue;
                node.setNestedNetwork(Cytoscape.getNetwork(titleToIdMap.get(nestedNetworkTitle)));
            }
        }
    }

    private Map<String, String> createNetworkTitleToIDMap() {
        HashMap<String, String> titleToIdMap = new HashMap<String, String>();
        Set<CyNetwork> networks = Cytoscape.getNetworkSet();
        for (CyNetwork network : networks) {
            titleToIdMap.put(network.getTitle(), network.getIdentifier());
        }
        return titleToIdMap;
    }

    private void deleteTmpPluginFiles() {
        if (this.pluginFileListMap == null || this.pluginFileListMap.size() == 0) {
            return;
        }
        Set<String> pluginSet = this.pluginFileListMap.keySet();
        for (String plugin : pluginSet) {
            List<File> theFileList = this.pluginFileListMap.get(plugin);
            for (File theFile : theFileList) {
                if (theFile == null) continue;
                theFile.delete();
            }
        }
    }

    private void unzipSessionFromURL(boolean loadVizmap) throws IOException, JAXBException, Exception {
        this.extractEntry();
        this.logger.info("extractEntry: " + (System.currentTimeMillis() - this.start) + " msec.");
        if (this.cysessionFileURL == null || this.vizmapFileURL == null || this.cytoscapePropsURL == null) {
            IOException e = new IOException("Session file is broken or this is not a session file.");
            throw e;
        }
        if (this.imagePropsURL != null) {
            this.restoreCustomGraphics();
        }
        if (loadVizmap) {
            Cytoscape.firePropertyChange(Cytoscape.VIZMAP_RESTORED, null, this.vizmapFileURL);
        }
        if (this.bookmarksFileURL != null) {
            this.bookmarks = this.getBookmarksFromZip(this.bookmarksFileURL);
            Cytoscape.setBookmarks(this.bookmarks);
        }
        CytoscapeInit.getProperties().load(URLUtil.getBasicInputStream(this.cytoscapePropsURL));
        this.loadCySession();
        this.restorePlugnStateFilesFromZip();
        this.restoreNestedNetworkLinks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void restorePlugnStateFilesFromZip() {
        if (this.theURLstrMap == null || this.theURLstrMap.size() == 0) {
            return;
        }
        pluginSet = this.theURLstrMap.keySet();
        for (String pluginName : pluginSet) {
            URLstrList = this.theURLstrMap.get(pluginName);
            if (URLstrList == null || URLstrList.size() == 0) continue;
            theFile = null;
            for (String URLstr : URLstrList) {
                index = URLstr.lastIndexOf("/");
                fileName = System.getProperty("java.io.tmpdir") + File.separator + pluginName + "_" + URLstr.substring(index + 1);
                theFile = new File(fileName);
                try {
                    theURL = new URL(URLstr);
                    is = null;
                    try {
                        is = URLUtil.getBasicInputStream(theURL);
                        in = null;
                        out = null;
                        in = new BufferedReader(new InputStreamReader(is));
                        try {
                            out = new BufferedWriter(new FileWriter(theFile));
                            try {
                                while ((inputLine = in.readLine()) != null) {
                                    out.write(inputLine);
                                    out.newLine();
                                }
                                var16_16 = null;
                                ** if (out == null) goto lbl-1000
                            }
                            catch (Throwable var15_19) {
                                var16_16 = null;
                                if (out != null) {
                                    out.close();
                                }
                                throw var15_19;
                            }
lbl-1000:
                            // 1 sources

                            {
                                out.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                            var18_17 = null;
                            ** if (in == null) goto lbl-1000
                        }
                        catch (Throwable var17_20) {
                            var18_17 = null;
                            if (in != null) {
                                in.close();
                            }
                            throw var17_20;
                        }
lbl-1000:
                        // 1 sources

                        {
                            in.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        var20_18 = null;
                        ** if (is == null) goto lbl-1000
                    }
                    catch (Throwable var19_21) {
                        var20_18 = null;
                        if (is != null) {
                            is.close();
                        }
                        throw var19_21;
                    }
lbl-1000:
                    // 1 sources

                    {
                        is.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (IOException e) {
                    theFile = null;
                    this.logger.error("Error: reading from zip: " + URLstr, e);
                }
                if (theFile == null) continue;
                if (!this.pluginFileListMap.containsKey(pluginName)) {
                    fileList = new ArrayList<File>();
                    fileList.add(theFile);
                    this.pluginFileListMap.put(pluginName, fileList);
                    continue;
                }
                fileList = this.pluginFileListMap.get(pluginName);
                fileList.add(theFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Bookmarks getBookmarksFromZip(URL pBookmarksFileURL) {
        Bookmarks theBookmark = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(BOOKMARK_PACKAGE_NAME, this.getClass().getClassLoader());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            InputStream is = null;
            try {
                is = URLUtil.getBasicInputStream(pBookmarksFileURL);
                theBookmark = (Bookmarks)unmarshaller.unmarshal(is);
                Object var7_9 = null;
                if (is == null) return theBookmark;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return theBookmark;
        }
        catch (FileNotFoundException e1) {
            this.logger.warn("Can not find bookmark file in " + pBookmarksFileURL.toString(), e1);
            return theBookmark;
        }
        catch (IOException e2) {
            this.logger.warn("Can not read bookmark file from " + pBookmarksFileURL.toString(), e2);
            return theBookmark;
        }
        catch (JAXBException e3) {
            this.logger.warn("XML parse err in bookmark file in " + pBookmarksFileURL.toString(), e3);
        }
        return theBookmark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadCySession() throws JAXBException, IOException, Exception {
        block5: {
            JAXBContext jaxbContext = JAXBContext.newInstance(PACKAGE_NAME, this.getClass().getClassLoader());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            InputStream is = null;
            try {
                is = URLUtil.getBasicInputStream(this.cysessionFileURL);
                this.session = (Cysession)unmarshaller.unmarshal(is);
                Object var5_4 = null;
                if (is == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (is != null) {
                    is.close();
                }
                throw throwable;
            }
            is.close();
        }
        this.sessionID = this.session.getId();
        this.netMap = new HashMap();
        Iterator<Network> i$ = this.session.getNetworkTree().getNetwork().iterator();
        while (true) {
            if (!i$.hasNext()) {
                this.walkTree(this.netMap.get(NETWORK_ROOT), null, this.cysessionFileURL);
                return;
            }
            Network curNet = i$.next();
            this.netMap.put(curNet.getId(), curNet);
        }
    }

    private void restoreDesktopState() {
        List<NetworkFrame> frames = this.session.getSessionState().getDesktop().getNetworkFrames().getNetworkFrame();
        HashMap<String, NetworkFrame> frameMap = new HashMap<String, NetworkFrame>();
        for (NetworkFrame netFrame : frames) {
            frameMap.put(netFrame.getFrameID(), netFrame);
        }
        Component[] desktopFrames = Cytoscape.getDesktop().getNetworkViewManager().getDesktopPane().getComponents();
        for (int i = 0; i < desktopFrames.length; ++i) {
            JInternalFrame frame;
            NetworkFrame nFrame;
            Component cmp = desktopFrames[i];
            if (!(cmp instanceof JInternalFrame) || (nFrame = (NetworkFrame)frameMap.get((frame = (JInternalFrame)cmp).getTitle())) == null) continue;
            frame.setSize(nFrame.getWidth().intValue(), nFrame.getHeight().intValue());
            frame.setLocation(nFrame.getX().intValue(), nFrame.getY().intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walkTree(Network currentNetwork, CyNetwork parent, Object sessionSource) throws JAXBException, IOException {
        List<Child> children = currentNetwork.getChild();
        int numChildren = children.size();
        for (int i = 0; i < numChildren; ++i) {
            Properties prop;
            String vsbSwitch;
            XGMMLReader reader;
            CyNetwork new_network;
            Network childNet;
            block13: {
                Child child = children.get(i);
                childNet = this.netMap.get(child.getId());
                String targetNwUrlName = this.sessionID + "/" + childNet.getFilename();
                URL targetNetworkURL = (URL)this.networkURLs.get(targetNwUrlName);
                if (targetNetworkURL == null) {
                    this.logger.error("Session file corrupt: Filename " + childNet.getFilename() + " does not correspond to a network of that name in session file");
                    continue;
                }
                new_network = null;
                JarURLConnection jarConnection = null;
                reader = null;
                vsbSwitch = null;
                prop = CytoscapeInit.getProperties();
                vsbSwitch = prop.getProperty("visualStyleBuilder");
                prop.setProperty("visualStyleBuilder", "off");
                jarConnection = (JarURLConnection)targetNetworkURL.openConnection();
                try {
                    Object var19_21;
                    InputStream networkStream = null;
                    try {
                        networkStream = (InputStream)jarConnection.getContent();
                        reader = new XGMMLReader(networkStream);
                        new_network = Cytoscape.createNetwork(reader, false, parent);
                        var19_21 = null;
                        if (networkStream == null) break block13;
                    }
                    catch (Throwable throwable) {
                        var19_21 = null;
                        if (networkStream != null) {
                            networkStream.close();
                        }
                        throw throwable;
                    }
                    networkStream.close();
                    {
                    }
                }
                catch (Exception e) {
                    String message = "Unable to read XGMML file: " + childNet.getFilename() + ".  " + e.getMessage();
                    this.logger.error(message, e);
                    Cytoscape.destroyNetwork(new_network);
                    if (this.taskMonitor != null) {
                        this.taskMonitor.setException(e, message);
                    }
                    if (childNet.getChild().size() == 0) continue;
                    this.walkTree(childNet, new_network, sessionSource);
                    continue;
                }
            }
            if (vsbSwitch != null) {
                prop.setProperty("visualStyleBuilder", vsbSwitch);
            } else {
                prop.remove("visualStyleBuilder");
            }
            if (this.taskMonitor != null && this.networkCounter >= 20.0f) {
                this.netIndex += 1.0f;
                this.taskMonitor.setPercentCompleted(((Number)Float.valueOf(this.netIndex / this.networkCounter * 100.0f)).intValue());
            }
            if (new_network == null) continue;
            this.logger.info("XGMMLReader " + new_network.getIdentifier() + ": " + (System.currentTimeMillis() - this.start) + " msec.");
            this.networkList.add(new_network.getIdentifier());
            if (childNet.isViewAvailable().booleanValue()) {
                String vsName = childNet.getVisualStyle();
                if (vsName == null) {
                    vsName = "default";
                }
                this.lastVSName = vsName;
                CyNetworkView curNetView = Cytoscape.createNetworkView(new_network, new_network.getTitle(), reader.getLayoutAlgorithm());
                curNetView.setVisualStyle(vsName);
                Cytoscape.getVisualMappingManager().setNetworkView(curNetView);
                Cytoscape.getVisualMappingManager().setVisualStyle(vsName);
                reader.doPostProcessing(new_network);
                this.setHiddenNodes(curNetView, childNet.getHiddenNodes());
                this.setHiddenEdges(curNetView, childNet.getHiddenEdges());
            }
            this.setSelectedNodes(new_network, childNet.getSelectedNodes());
            this.setSelectedEdges(new_network, childNet.getSelectedEdges());
            if (childNet.getChild().size() == 0) continue;
            this.walkTree(childNet, new_network, sessionSource);
        }
    }

    private void setSelectedNodes(CyNetwork network, SelectedNodes selected) {
        if (selected == null) {
            return;
        }
        ArrayList<CyNode> selectedNodeList = new ArrayList<CyNode>();
        for (Node selectedNode : selected.getNode()) {
            selectedNodeList.add(Cytoscape.getCyNode(selectedNode.getId(), false));
        }
        network.setSelectedNodeState(selectedNodeList, true);
    }

    private void setHiddenNodes(CyNetworkView view, HiddenNodes hidden) {
        if (hidden == null) {
            return;
        }
        for (Node hiddenNodeObject : hidden.getNode()) {
            CyNode hiddenNode = Cytoscape.getCyNode(hiddenNodeObject.getId(), false);
            view.hideGraphObject(view.getNodeView(hiddenNode));
        }
    }

    private void setHiddenEdges(CyNetworkView view, HiddenEdges hidden) {
        if (hidden == null) {
            return;
        }
        for (Edge hiddenEdgeObject : hidden.getEdge()) {
            CyEdge hiddenEdge = this.getCyEdge(hiddenEdgeObject);
            if (hiddenEdge == null) continue;
            view.hideGraphObject(view.getEdgeView(hiddenEdge));
        }
    }

    private void setSelectedEdges(CyNetwork network, SelectedEdges selected) {
        if (selected == null) {
            return;
        }
        CyEdge targetEdge = null;
        ArrayList<CyEdge> selectedEdgeList = new ArrayList<CyEdge>();
        for (Edge selectedEdge : selected.getEdge()) {
            targetEdge = this.getCyEdge(selectedEdge);
            if (targetEdge == null) continue;
            selectedEdgeList.add(targetEdge);
        }
        network.setSelectedEdgeState(selectedEdgeList, true);
    }

    private CyEdge getCyEdge(Edge edge) {
        String[] parts;
        CyEdge targetEdge = null;
        String sourceString = edge.getSource();
        String targetString = edge.getTarget();
        CyNode source = null;
        CyNode target = null;
        String interaction = edge.getInteraction();
        if (sourceString != null && targetString != null) {
            source = Cytoscape.getCyNode(sourceString);
            target = Cytoscape.getCyNode(targetString);
        }
        if (source != null & target != null && interaction != null) {
            targetEdge = Cytoscape.getCyEdge(source, target, "interaction", interaction, false, true);
        }
        if (targetEdge == null && (parts = edge.getId().split(" ")).length == 3) {
            source = Cytoscape.getCyNode(parts[0], false);
            target = Cytoscape.getCyNode(parts[2], false);
            interaction = parts[1].substring(1, parts[1].length() - 1);
            if (source != null && target != null && interaction != null) {
                targetEdge = Cytoscape.getCyEdge(source, target, "interaction", interaction, false, true);
            }
        }
        return targetEdge;
    }

    public String getCysessionNote() {
        return this.session.getSessionNote();
    }

    private void restoreOntologyServerStatus() throws MalformedURLException {
        HashMap<String, URL> newMap = new HashMap<String, URL>();
        List<cytoscape.generated.Ontology> servers = this.session.getSessionState().getServer().getOntologyServer().getOntology();
        String targetCyNetworkID = null;
        String curator = null;
        String description = null;
        for (cytoscape.generated.Ontology server : servers) {
            newMap.put(server.getName(), new URL(server.getHref()));
            targetCyNetworkID = this.getNetworkIdFromTitle(server.getName());
            Ontology onto = new Ontology(server.getName(), curator, description, Cytoscape.getNetwork(targetCyNetworkID));
            Cytoscape.getOntologyServer().addOntology(onto);
        }
        Cytoscape.getOntologyServer().setOntologySources(newMap);
    }

    private String getNetworkIdFromTitle(String title) {
        Set<CyNetwork> networks = Cytoscape.getNetworkSet();
        for (CyNetwork net : networks) {
            if (!net.getTitle().equals(title)) continue;
            return net.getIdentifier();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL temporaryLocalFileURL(URL remoteURL) {
        try {
            File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".cys");
            tempFile.deleteOnExit();
            byte[] buffer = new byte[100000];
            FileOutputStream localContent = new FileOutputStream(tempFile);
            try {
                block9: {
                    InputStream remoteContent = URLUtil.getBasicInputStream(remoteURL);
                    try {
                        int nBytes = remoteContent.read(buffer);
                        while (nBytes > 0) {
                            ((OutputStream)localContent).write(buffer, 0, nBytes);
                            nBytes = remoteContent.read(buffer);
                        }
                        Object var8_10 = null;
                        if (remoteContent == null) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        if (remoteContent == null) throw throwable;
                        remoteContent.close();
                        throw throwable;
                    }
                    remoteContent.close();
                }
                Object var10_13 = null;
                if (localContent == null) return tempFile.toURL();
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (localContent == null) throw throwable;
                ((OutputStream)localContent).close();
                throw throwable;
            }
            ((OutputStream)localContent).close();
            return tempFile.toURL();
        }
        catch (FileNotFoundException e) {
            this.logger.error("Can't create a temporary file.", e);
            return remoteURL;
        }
        catch (MalformedURLException e) {
            this.logger.error("Bad URL provided: " + remoteURL.toString(), e);
            return remoteURL;
        }
        catch (IOException e) {
            this.logger.error("I/O error while cacheing URL data", e);
        }
        return remoteURL;
    }
}

