/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyCommandResult {
    private boolean errors = false;
    private List<String> messages = new ArrayList<String>();
    private List<String> errorMessages = new ArrayList<String>();
    private Map<String, Object> results = null;

    public CyCommandResult() {
    }

    public CyCommandResult(String message, Map<String, Object> results) {
        this();
        this.messages.add(message);
        this.results = results;
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }

    public void addError(String message) {
        this.errorMessages.add(message);
        this.errors = true;
    }

    public void addResult(Object value) {
        if (this.results == null) {
            this.results = new HashMap<String, Object>();
        }
        this.results.put("", value);
    }

    public void addResult(String key, Object value) {
        if (this.results == null) {
            this.results = new HashMap<String, Object>();
        }
        this.results.put(key, value);
    }

    public boolean successful() {
        return !this.errors;
    }

    public void setResults(Map<String, Object> results) {
        this.results = results;
    }

    public String getStringResult(String key) {
        if (this.results != null && this.results.containsKey(key)) {
            return this.results.get(key).toString();
        }
        return null;
    }

    public String getStringResult() {
        return this.getStringResult("");
    }

    public Object getResult(String key) {
        if (this.results != null && this.results.containsKey(key)) {
            return this.results.get(key);
        }
        return null;
    }

    public Object getResult() {
        return this.getResult("");
    }

    public Map<String, Object> getResults() {
        return this.results;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public List<String> getErrors() {
        return this.errorMessages;
    }
}

