/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.dialogs.plugins.PluginUpdateDialog;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.PluginStatus;
import cytoscape.util.CytoscapeAction;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.jdom.JDOMException;

public class PluginUpdateAction
extends CytoscapeAction {
    protected static CyLogger logger = CyLogger.getLogger(PluginUpdateAction.class);

    public PluginUpdateAction() {
        super("Update Plugins");
        this.setPreferredMenu("Plugins");
        if (PluginManager.usingWebstartManager()) {
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PluginUpdateDialog dialog = new PluginUpdateDialog(Cytoscape.getDesktop());
        dialog.setVisible(false);
        ArrayList<String> xmlIncorrect = new ArrayList<String>();
        if (!PluginManager.usingWebstartManager()) {
            boolean updateFound = false;
            PluginManager mgr = PluginManager.getPluginManager();
            for (DownloadableInfo current : mgr.getDownloadables(PluginStatus.CURRENT)) {
                try {
                    List<DownloadableInfo> updates = mgr.findUpdates(current);
                    if (updates.size() <= 0) continue;
                    dialog.addCategory(current.getCategory(), current, updates);
                    updateFound = true;
                }
                catch (JDOMException jde) {
                    logger.warn(jde.getMessage());
                    xmlIncorrect.add(current.toString());
                }
                catch (IOException ioe) {
                    logger.warn("Failed to read XML file for " + current.getName() + " at " + current.getDownloadableURL(), ioe);
                    xmlIncorrect.add(current.toString());
                }
            }
            if (xmlIncorrect.size() > 0) {
                // empty if block
            }
            if (updateFound) {
                dialog.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "No updates available for currently installed plugins.", "Plugin Updates", 1);
            }
        } else {
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Plugin updates are not available when using Cytoscape through webstart", "Plugin Update", 1);
        }
    }
}

