/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.cytopanels.CytoPanelName;
import cytoscape.view.cytopanels.CytoPanelState;
import java.awt.event.ActionEvent;
import javax.swing.event.MenuEvent;

public class CytoPanelAction
extends CytoscapeAction {
    private static final long serialVersionUID = 2069061664423847850L;
    protected static final String SHOW = "Show";
    protected static final String HIDE = "Hide";
    protected String title;
    protected int position;
    protected CytoPanelName parent = null;

    public CytoPanelAction(CytoPanelName cp, boolean show, CytoPanelName parent) {
        this(cp.getTitle(), cp.getCompassDirection(), show);
        this.parent = parent;
    }

    private CytoPanelAction(String title, int position, boolean show) {
        super(show ? "Hide " + title : "Show " + title);
        this.title = title;
        this.position = position;
        this.setPreferredMenu("View");
    }

    public void actionPerformed(ActionEvent ev) {
        CytoPanelState curState = Cytoscape.getDesktop().getCytoPanel(this.position).getState();
        if (curState == CytoPanelState.HIDE) {
            Cytoscape.getDesktop().getCytoPanel(this.position).setState(CytoPanelState.DOCK);
        } else {
            Cytoscape.getDesktop().getCytoPanel(this.position).setState(CytoPanelState.HIDE);
        }
    }

    public void menuSelected(MenuEvent me) {
        CytoPanelState curState;
        if (this.parent != null) {
            CytoPanelState parentState = Cytoscape.getDesktop().getCytoPanel(this.parent.getCompassDirection()).getState();
            if (parentState == CytoPanelState.HIDE) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
        if ((curState = Cytoscape.getDesktop().getCytoPanel(this.position).getState()) == CytoPanelState.HIDE) {
            this.putValue("Name", "Show " + this.title);
        } else {
            this.putValue("Name", "Hide " + this.title);
        }
    }
}

