/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf;

import com.sun.glf.Anchor;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Position;
import com.sun.glf.goodies.GaussianKernel;
import com.sun.glf.util.CompositionComponent;
import com.sun.glf.util.Toolbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import javax.swing.JFrame;

public class ImageLayer
extends Layer {
    private Image image;
    static final String USAGE = "java com.sun.glf.ImageLayer <imageFile or URL> <width> <height>";

    public Rectangle2D getBounds() {
        return new Rectangle(0, 0, this.image.getWidth(null), this.image.getHeight(null));
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.drawImage(this.image, 0, 0, null);
    }

    public ImageLayer(LayerComposition layerComposition, Image image) {
        this(layerComposition, image, null);
    }

    public ImageLayer(LayerComposition layerComposition, Image image, Position position) {
        super(layerComposition);
        if (image == null) {
            throw new IllegalArgumentException("Cannot paint null image");
        }
        this.image = image;
        if (position != null) {
            Rectangle rectangle = new Rectangle(image.getWidth(null), image.getHeight(null));
            this.setTransform(position.getTransform(rectangle, layerComposition.getBounds()));
        }
    }

    public Image getImage() {
        return this.image;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println(USAGE);
            System.exit(0);
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        BufferedImage bufferedImage = Toolbox.loadImage(string, 1);
        Dimension dimension = new Dimension(n, n2);
        float f = 0.1f * (float)n / (float)bufferedImage.getWidth();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(f, f), renderingHints);
        bufferedImage = affineTransformOp.filter(bufferedImage, null);
        final JFrame jFrame = new JFrame("ImageLayer unit testing");
        jFrame.getContentPane().setLayout(new GridLayout(0, 4));
        jFrame.getContentPane().setBackground(Color.white);
        CompositionComponent compositionComponent = null;
        Color color = Color.black;
        LayerComposition layerComposition = new LayerComposition(dimension);
        ImageLayer imageLayer = new ImageLayer(layerComposition, bufferedImage);
        layerComposition.setLayers(new Layer[]{imageLayer});
        layerComposition.setBackgroundPaint(color);
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("Simple ImageLayer");
        jFrame.getContentPane().add(compositionComponent);
        int n3 = Anchor.enumValues.length;
        Layer[] layerArray = new Layer[n3];
        ConvolveOp convolveOp = new ConvolveOp(new GaussianKernel(4));
        for (int i = 0; i < n3; ++i) {
            layerArray[i] = new ImageLayer(layerComposition, bufferedImage, new Position(Anchor.enumValues[i]));
            layerArray[i].setImageFilter(convolveOp, new Dimension(4, 4));
        }
        layerComposition = new LayerComposition(dimension);
        layerComposition.setLayers(layerArray);
        layerComposition.setBackgroundPaint(color);
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("ImageLayers using different anchor values");
        jFrame.getContentPane().add(compositionComponent);
        float f2 = 30.0f;
        float f3 = 50.0f;
        layerArray = new ImageLayer[n3];
        for (int i = 0; i < n3; ++i) {
            layerArray[i] = new ImageLayer(layerComposition, bufferedImage, new Position(Anchor.enumValues[i], f3, f2));
        }
        layerComposition = new LayerComposition(dimension);
        layerComposition.setLayers(layerArray);
        layerComposition.setBackgroundPaint(color);
        compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText("ImageLayers using different anchor values and adjustment");
        jFrame.getContentPane().add(compositionComponent);
        AffineTransform[] affineTransformArray = new AffineTransform[]{AffineTransform.getTranslateInstance(20.0, 20.0), AffineTransform.getScaleInstance(2.0, 2.0), AffineTransform.getScaleInstance(1.0, -1.0), AffineTransform.getRotateInstance(0.7853981633974483), AffineTransform.getShearInstance(-0.2, -0.2)};
        for (int i = 0; i < affineTransformArray.length; ++i) {
            layerArray = new ImageLayer[n3];
            for (int j = 0; j < n3; ++j) {
                layerArray[j] = new ImageLayer(layerComposition, bufferedImage, new Position(Anchor.enumValues[j], f3, f2, affineTransformArray[i]));
            }
            layerComposition = new LayerComposition(dimension);
            layerComposition.setLayers(layerArray);
            layerComposition.setBackgroundPaint(color);
            compositionComponent = new CompositionComponent(layerComposition);
            compositionComponent.setToolTipText("ImageLayers using different anchor values, adjustments and adjustment transform");
            jFrame.getContentPane().add(compositionComponent);
        }
        jFrame.pack();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }
}

