/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.Utilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Jpeg
extends Image {
    public static final int NOT_A_MARKER = -1;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    public static final int M_APP0 = 224;
    public static final int M_APPE = 238;
    public static final byte[] JFIF_ID = new byte[]{74, 70, 73, 70, 0};

    Jpeg(Image image) {
        super(image);
    }

    public Jpeg(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Jpeg(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.processParameters();
    }

    public Jpeg(byte[] byArray, float f, float f2) throws BadElementException, IOException {
        this(byArray);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    private static final int getShort(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    private static final int marker(int n) {
        int n2;
        for (n2 = 0; n2 < VALID_MARKERS.length; ++n2) {
            if (n != VALID_MARKERS[n2]) continue;
            return 0;
        }
        for (n2 = 0; n2 < NOPARAM_MARKERS.length; ++n2) {
            if (n != NOPARAM_MARKERS[n2]) continue;
            return 2;
        }
        for (n2 = 0; n2 < UNSUPPORTED_MARKERS.length; ++n2) {
            if (n != UNSUPPORTED_MARKERS[n2]) continue;
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processParameters() throws BadElementException, IOException {
        block21: {
            this.type = 32;
            this.originalType = 1;
            InputStream inputStream = null;
            try {
                String string;
                if (this.rawData == null) {
                    inputStream = this.url.openStream();
                    string = this.url.toString();
                } else {
                    inputStream = new ByteArrayInputStream(this.rawData);
                    string = "Byte array";
                }
                if (inputStream.read() != 255) throw new BadElementException(string + " is not a valid JPEG-file.");
                if (inputStream.read() != 216) {
                    throw new BadElementException(string + " is not a valid JPEG-file.");
                }
                boolean bl = true;
                while (true) {
                    int n;
                    int n2;
                    if ((n2 = inputStream.read()) < 0) {
                        throw new IOException("Premature EOF while reading JPG.");
                    }
                    if (n2 != 255) continue;
                    int n3 = inputStream.read();
                    if (bl && n3 == 224) {
                        int n4;
                        bl = false;
                        n = Jpeg.getShort(inputStream);
                        if (n < 16) {
                            Utilities.skip(inputStream, n - 2);
                            continue;
                        }
                        byte[] byArray = new byte[JFIF_ID.length];
                        int n5 = inputStream.read(byArray);
                        if (n5 != byArray.length) {
                            throw new BadElementException(string + " corrupted JFIF marker.");
                        }
                        boolean bl2 = true;
                        for (n4 = 0; n4 < byArray.length; ++n4) {
                            if (byArray[n4] == JFIF_ID[n4]) continue;
                            bl2 = false;
                            break;
                        }
                        if (!bl2) {
                            Utilities.skip(inputStream, n - 2 - byArray.length);
                            continue;
                        }
                        Utilities.skip(inputStream, 2);
                        n4 = inputStream.read();
                        int n6 = Jpeg.getShort(inputStream);
                        int n7 = Jpeg.getShort(inputStream);
                        if (n4 == 1) {
                            this.dpiX = n6;
                            this.dpiY = n7;
                        } else if (n4 == 2) {
                            this.dpiX = (int)((float)n6 * 2.54f + 0.5f);
                            this.dpiY = (int)((float)n7 * 2.54f + 0.5f);
                        }
                        Utilities.skip(inputStream, n - 2 - byArray.length - 7);
                        continue;
                    }
                    if (n3 == 238) {
                        String string2;
                        n = Jpeg.getShort(inputStream) - 2;
                        byte[] byArray = new byte[n];
                        for (int i = 0; i < n; ++i) {
                            byArray[i] = (byte)inputStream.read();
                        }
                        if (byArray.length < 12 || !(string2 = new String(byArray, 0, 5, "ISO-8859-1")).equals("Adobe")) continue;
                        this.invert = true;
                        continue;
                    }
                    bl = false;
                    int n8 = Jpeg.marker(n3);
                    if (n8 == 0) {
                        Utilities.skip(inputStream, 2);
                        if (inputStream.read() != 8) {
                            throw new BadElementException(string + " must have 8 bits per component.");
                        }
                        this.scaledHeight = Jpeg.getShort(inputStream);
                        this.setTop(this.scaledHeight);
                        this.scaledWidth = Jpeg.getShort(inputStream);
                        this.setRight(this.scaledWidth);
                        this.colorspace = inputStream.read();
                        this.bpc = 8;
                        Object var14_17 = null;
                        if (inputStream == null) break block21;
                        break;
                    }
                    if (n8 == 1) {
                        throw new BadElementException(string + ": unsupported JPEG marker: " + n3);
                    }
                    if (n8 == 2) continue;
                    Utilities.skip(inputStream, Jpeg.getShort(inputStream) - 2);
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                this.plainWidth = this.getWidth();
                this.plainHeight = this.getHeight();
                throw throwable;
            }
            inputStream.close();
        }
        this.plainWidth = this.getWidth();
        this.plainHeight = this.getHeight();
    }
}

