/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.AttributeList;
import javax.management.relation.RoleList;
import javax.management.relation.RoleUnresolvedList;
import org.cytoscape.equations.BooleanList;
import org.cytoscape.equations.DoubleList;
import org.cytoscape.equations.EquationUtil;
import org.cytoscape.equations.FunctionError;
import org.cytoscape.equations.LongList;
import org.cytoscape.equations.StringList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionUtil {
    public static double getArgAsDouble(Object arg) throws IllegalArgumentException {
        if (arg.getClass() == Double.class) {
            return (Double)arg;
        }
        if (arg.getClass() == Long.class) {
            return ((Long)arg).longValue();
        }
        if (arg.getClass() == String.class) {
            try {
                return Double.parseDouble((String)arg);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("can't convert \"" + arg + "\" to a floating point number!");
            }
        }
        if (arg.getClass() == Boolean.class) {
            return (Boolean)arg != false ? 1.0 : 0.0;
        }
        throw new IllegalArgumentException("can't convert argument to a floating point number!");
    }

    public static String getArgAsString(Object arg) throws IllegalArgumentException {
        if (arg.getClass() == Boolean.class) {
            return (Boolean)arg != false ? "TRUE" : "FALSE";
        }
        if (arg.getClass() == Double.class) {
            int length;
            String asString = arg.toString();
            for (length = asString.length(); length > 1 && asString.charAt(length - 1) == '0'; --length) {
            }
            if (asString.charAt(length - 1) == '.' || asString.charAt(length - 1) == ',') {
                --length;
            }
            return asString.substring(0, length);
        }
        return arg.toString();
    }

    public static long getArgAsLong(Object arg) throws IllegalArgumentException {
        if (arg.getClass() == Double.class) {
            return EquationUtil.doubleToLong((Double)arg);
        }
        if (arg.getClass() == Long.class) {
            return (Long)arg;
        }
        if (arg.getClass() == String.class) {
            try {
                return Long.parseLong((String)arg);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("can't convert \"" + arg + "\" to a whole number!");
            }
        }
        if (arg.getClass() == Boolean.class) {
            return (Boolean)arg != false ? 1L : 0L;
        }
        throw new IllegalArgumentException("can't convert argument to a whole number!");
    }

    public static boolean getArgAsBoolean(Object arg) throws IllegalArgumentException {
        if (arg.getClass() == Double.class) {
            double d = (Double)arg;
            return d != 0.0;
        }
        if (arg.getClass() == Long.class) {
            long l = (Long)arg;
            return l != 0L;
        }
        if (arg.getClass() == String.class) {
            String argAsString = (String)arg;
            if (argAsString.equalsIgnoreCase(Boolean.valueOf(true).toString())) {
                return true;
            }
            if (argAsString.equalsIgnoreCase(Boolean.valueOf(false).toString())) {
                return false;
            }
            throw new IllegalArgumentException("can't convert \"" + argAsString + "\" to a boolean!");
        }
        if (arg.getClass() == Boolean.class) {
            return (Boolean)arg;
        }
        throw new IllegalArgumentException("can't convert argument to a boolean!");
    }

    public static double numericallySafeSum(double[] a) {
        int positiveCount = 0;
        for (double d : a) {
            if (!(d >= 0.0)) continue;
            ++positiveCount;
        }
        double[] positiveValues = new double[positiveCount];
        double[] negativeValues = new double[a.length - positiveCount];
        int positiveIndex = 0;
        int negativeIndex = 0;
        for (double d : a) {
            if (d >= 0.0) {
                positiveValues[positiveIndex++] = d;
                continue;
            }
            negativeValues[negativeIndex++] = d;
        }
        double positiveSum = 0.0;
        if (positiveValues.length > 0) {
            Arrays.sort(positiveValues);
            for (double d : positiveValues) {
                positiveSum += d;
            }
        }
        double negativeSum = 0.0;
        if (negativeValues.length > 0) {
            Arrays.sort(negativeValues);
            for (int i = negativeValues.length - 1; i >= 0; --i) {
                negativeSum += negativeValues[i];
            }
        }
        return positiveSum + negativeSum;
    }

    public static String getOrdinal(int i) {
        if (i % 100 == 11) {
            return Integer.toString(i) + "th";
        }
        switch (i % 10) {
            case 1: {
                return Integer.toString(i) + "st";
            }
            case 2: {
                return Integer.toString(i) + "nd";
            }
            case 3: {
                return Integer.toString(i) + "rd";
            }
        }
        return Integer.toString(i) + "th";
    }

    public static double calcSampleVariance(double[] x) {
        int N = x.length;
        if (N < 2) {
            throw new IllegalArgumentException("can't calculate a variance with fewer than 2 values!");
        }
        double[] xSquared = new double[N];
        for (int i = 0; i < N; ++i) {
            xSquared[i] = x[i] * x[i];
        }
        double sumOfX = FunctionUtil.numericallySafeSum(x);
        double sumOfXSquared = FunctionUtil.numericallySafeSum(xSquared);
        return (sumOfXSquared - sumOfX * sumOfX / (double)N) / (double)(N - 1);
    }

    public static double[] listToArray(List<Double> a) {
        double[] x = new double[a.size()];
        int i = 0;
        for (double d : a) {
            x[i++] = d;
        }
        return x;
    }

    public static boolean isScalarArgType(Class type) {
        return type == Double.class || type == Long.class || type == String.class || type == Boolean.class;
    }

    public static boolean isSomeKindOfList(Class listClassCandidate) {
        if (listClassCandidate == List.class) {
            return true;
        }
        if (listClassCandidate == ArrayList.class) {
            return true;
        }
        if (listClassCandidate == DoubleList.class) {
            return true;
        }
        if (listClassCandidate == StringList.class) {
            return true;
        }
        if (listClassCandidate == LongList.class) {
            return true;
        }
        if (listClassCandidate == BooleanList.class) {
            return true;
        }
        if (listClassCandidate == Vector.class) {
            return true;
        }
        if (listClassCandidate == Stack.class) {
            return true;
        }
        if (listClassCandidate == AttributeList.class) {
            return true;
        }
        if (listClassCandidate == CopyOnWriteArrayList.class) {
            return true;
        }
        if (listClassCandidate == LinkedList.class) {
            return true;
        }
        if (listClassCandidate == RoleList.class) {
            return true;
        }
        return listClassCandidate == RoleUnresolvedList.class;
    }

    public static void addScalarArgumentTypes(List<Class> argTypes) {
        argTypes.add(Double.class);
        argTypes.add(Long.class);
        argTypes.add(String.class);
        argTypes.add(Boolean.class);
    }

    public static double[] getDoubles(Object[] args) throws FunctionError {
        ArrayList<Double> numbers = new ArrayList<Double>();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof List) {
                List list = (List)arg;
                for (Object listElement : list) {
                    Double d = FunctionUtil.convertToDouble(listElement);
                    if (d == null) {
                        throw new FunctionError("can't convert list element \"" + listElement + "\" to a number!", i);
                    }
                    numbers.add(d);
                }
                continue;
            }
            Double d = FunctionUtil.convertToDouble(arg);
            if (d == null) {
                throw new FunctionError("can't convert \"" + arg + "\" to a number!", i);
            }
            numbers.add(d);
        }
        double[] doubles = new double[numbers.size()];
        int index = 0;
        for (Double d : numbers) {
            doubles[index++] = d;
        }
        return doubles;
    }

    public static long[] getLongs(Object[] args) throws FunctionError {
        ArrayList<Long> numbers = new ArrayList<Long>();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof List) {
                List list = (List)arg;
                for (Object listElement : list) {
                    Long l = FunctionUtil.convertToLong(listElement);
                    if (l == null) {
                        throw new FunctionError("can't convert list element \"" + listElement + "\" to an integer!", i);
                    }
                    numbers.add(l);
                }
                continue;
            }
            Long l = FunctionUtil.convertToLong(arg);
            if (l == null) {
                throw new FunctionError("can't convert \"" + arg + "\" to an integer!", i);
            }
            numbers.add(l);
        }
        long[] longs = new long[numbers.size()];
        int index = 0;
        for (Long l : numbers) {
            longs[index++] = l;
        }
        return longs;
    }

    public static String[] getStrings(Object[] args) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object arg : args) {
            if (arg instanceof List) {
                List list = (List)arg;
                for (Object listElement : list) {
                    strings.add(FunctionUtil.getArgAsString(listElement));
                }
                continue;
            }
            strings.add(FunctionUtil.getArgAsString(arg));
        }
        String[] retVal = new String[strings.size()];
        return strings.toArray(retVal);
    }

    public static boolean[] getBooleans(Object[] args) throws FunctionError {
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof List) {
                List list = (List)arg;
                for (Object listElement : list) {
                    Boolean b = FunctionUtil.convertToBoolean(listElement);
                    if (b == null) {
                        throw new FunctionError("can't convert list element \"" + listElement + "\" to a boolean value!", i);
                    }
                    booleans.add(b);
                }
                continue;
            }
            Boolean b = FunctionUtil.convertToBoolean(arg);
            if (b == null) {
                throw new FunctionError("can't convert \"" + arg + "\" to a boolean number!", i);
            }
            booleans.add(b);
        }
        boolean[] retval = new boolean[booleans.size()];
        int index = 0;
        for (Boolean b : booleans) {
            retval[index++] = b;
        }
        return retval;
    }

    private static Double convertToDouble(Object arg) {
        if (arg.getClass() == Double.class) {
            return (Double)arg;
        }
        if (arg.getClass() == Long.class) {
            return (double)((Long)arg);
        }
        if (arg.getClass() == Integer.class) {
            return (double)((Integer)arg);
        }
        if (arg.getClass() == String.class) {
            try {
                return Double.valueOf((String)arg);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (arg.getClass() == Boolean.class) {
            return (Boolean)arg != false ? 1.0 : 0.0;
        }
        return null;
    }

    private static Long convertToLong(Object arg) {
        if (arg.getClass() == Double.class) {
            return EquationUtil.doubleToLong((Double)arg);
        }
        if (arg.getClass() == Long.class) {
            return (Long)arg;
        }
        if (arg.getClass() == Integer.class) {
            return (long)((Integer)arg);
        }
        if (arg.getClass() == String.class) {
            try {
                return Long.valueOf((String)arg);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (arg.getClass() == Boolean.class) {
            return (Boolean)arg != false ? 1L : 0L;
        }
        return null;
    }

    private static Boolean convertToBoolean(Object arg) {
        if (arg.getClass() == Double.class) {
            return (Double)arg != 0.0;
        }
        if (arg.getClass() == Long.class) {
            return (double)((Long)arg).longValue() != 0.0;
        }
        if (arg.getClass() == Integer.class) {
            return (double)((Integer)arg).intValue() != 0.0;
        }
        if (arg.getClass() == String.class) {
            String s = (String)arg;
            if (s.equalsIgnoreCase("true")) {
                return true;
            }
            if (s.equalsIgnoreCase("false")) {
                return false;
            }
            return null;
        }
        if (arg.getClass() == Boolean.class) {
            return (Boolean)arg;
        }
        return null;
    }

    public static Object translateObjectType(Object input) {
        Class<?> type = input.getClass();
        if (type == Double.class || type == Long.class || type == Boolean.class || type == String.class) {
            return input;
        }
        if (type == Float.class) {
            return new Double(((Float)input).floatValue());
        }
        if (type == Integer.class) {
            return new Long(((Integer)input).intValue());
        }
        if (type == Short.class) {
            return new Long(((Short)input).shortValue());
        }
        if (type == Byte.class) {
            return new Long(((Byte)input).byteValue());
        }
        if (type == Character.class) {
            return new Long(((Character)input).charValue());
        }
        return null;
    }
}

