/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.List;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.BooleanList;
import org.cytoscape.equations.DoubleList;
import org.cytoscape.equations.FunctionUtil;
import org.cytoscape.equations.LongList;
import org.cytoscape.equations.StringList;

public class ArgDescriptor {
    private ArgType argType;
    private String argName;
    private String description;

    public ArgDescriptor(ArgType argType, String argName, String description) {
        this.argType = argType;
        this.argName = argName;
        this.description = description;
    }

    public ArgType getArgType() {
        return this.argType;
    }

    public String getArgName() {
        return this.argName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isOptional() {
        return this.argType.isOptional();
    }

    public boolean isCompatibleWith(Class type) {
        if (FunctionUtil.isSomeKindOfList(type)) {
            return this.isCompatibleList(type);
        }
        for (Class compatibleType : this.argType.getCompatibleTypes()) {
            if (type != compatibleType) continue;
            return true;
        }
        return false;
    }

    private boolean isSpecificList(Class type) {
        return type == DoubleList.class || type == LongList.class || type == StringList.class || type == BooleanList.class;
    }

    private boolean isCompatibleList(Class listType) {
        if (this.isSpecificList(listType)) {
            for (Class compatibleType : this.argType.getCompatibleTypes()) {
                if (compatibleType != listType && compatibleType != List.class) continue;
                return true;
            }
            return false;
        }
        for (Class compatibleType : this.argType.getCompatibleTypes()) {
            if (!FunctionUtil.isSomeKindOfList(compatibleType)) continue;
            return true;
        }
        return false;
    }

    public Class[] getCompatibleTypes() {
        return this.argType.getCompatibleTypes();
    }

    public boolean acceptsMultipleArgs() {
        return this.argType.acceptsMultipleArgs();
    }
}

