/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.utils.MergingIterator;
import org.biojava.utils.SmallSet;

public class MergingSet
extends AbstractSet {
    private final Set sets;
    private Set modifiable;

    public static MergingSet merge(Set first, Set seccond) {
        MergingSet ms = new MergingSet();
        ms.add(first);
        ms.add(seccond);
        return ms;
    }

    public static MergingSet modifiableMerge() {
        MergingSet ms = new MergingSet();
        ms.modifiable = new HashSet();
        ms.addSet(ms.modifiable);
        return ms;
    }

    public static MergingSet modifiableMerge(Set original) {
        MergingSet ms = new MergingSet();
        ms.modifiable = new HashSet();
        ms.addSet(ms.modifiable);
        ms.addSet(original);
        return ms;
    }

    public MergingSet() {
        this.sets = new SmallSet();
    }

    public MergingSet(Set sets) {
        this.sets = new SmallSet(sets);
    }

    public void addSet(Set set) {
        this.sets.add(set);
    }

    public boolean removeSet(Set set) {
        if (set == this.modifiable) {
            throw new IllegalArgumentException("Can't remove the set that contains modifications");
        }
        return this.sets.remove(set);
    }

    public Set getModifiable() {
        return this.modifiable;
    }

    public int size() {
        int size = 0;
        Iterator i = this.sets.iterator();
        while (i.hasNext()) {
            Set s = (Set)i.next();
            size += s.size();
        }
        return size;
    }

    public boolean contains(Object o) {
        Iterator i = this.sets.iterator();
        while (i.hasNext()) {
            Set s = (Set)i.next();
            if (!s.contains(o)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new MergingIterator(this.sets.iterator());
    }

    public boolean add(Object o) {
        if (this.modifiable == null) {
            throw new UnsupportedOperationException();
        }
        return this.modifiable.add(o);
    }

    public boolean remove(Object o) {
        if (this.modifiable == null) {
            throw new UnsupportedOperationException();
        }
        if (this.contains(o) && !this.modifiable.contains(o)) {
            throw new IllegalArgumentException("Can't remove items not added to this merged view");
        }
        return this.modifiable.remove(o);
    }
}

