/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Collections;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbol;
import org.biojava.utils.ListTools;

abstract class AbstractSimpleBasisSymbol
extends SimpleSymbol
implements BasisSymbol {
    protected List symbols;

    protected AbstractSimpleBasisSymbol(Annotation annotation, List symbols) throws IllegalSymbolException {
        this(annotation);
        if (symbols == null) {
            throw new NullPointerException("symbols can't be null");
        }
        if (symbols.size() == 0) {
            throw new IllegalSymbolException("Can't create BasisSymbol for an empty list. Use the Gap symbol.");
        }
        this.symbols = ListTools.createList(symbols);
    }

    protected AbstractSimpleBasisSymbol(Annotation annotation) {
        super(annotation);
    }

    public AbstractSimpleBasisSymbol(Annotation annotation, Alphabet matches) {
        this(annotation);
        this.matches = matches;
        this.symbols = Collections.nCopies(1, this);
    }

    public AbstractSimpleBasisSymbol(Annotation annotation, List symbols, Alphabet matches) throws IllegalSymbolException {
        this(annotation, symbols);
        this.matches = matches;
    }

    public final List getSymbols() {
        if (this.symbols == null) {
            this.symbols = this.createSymbols();
        }
        if (this.symbols.size() == 0) {
            throw new BioError("Assertion Failure: symbols array is of length 0 in " + this + "\n\tname: " + this.getName() + "\n\tsymbols: " + this.symbols + "\n\tmatches: " + this.matches);
        }
        return this.symbols;
    }

    protected List createSymbols() {
        throw new BioError("Assertion Failure: Symbols list is null");
    }
}

