/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.PDBFileParser;
import org.biojava.bio.structure.io.StructureIOFile;

public class PDBFileReader
implements StructureIOFile {
    String path = "";
    ArrayList extensions = new ArrayList();

    public void setPath(String p) {
        this.path = p;
    }

    public String getPath() {
        return this.path;
    }

    public void addExtension(String s) {
        this.extensions.add(s);
    }

    private FileInputStream getInputStream(String pdbId) throws IOException {
        String[] str = new String[]{".gz", ".zip", ".Z"};
        ArrayList<String> compressions = new ArrayList<String>(Arrays.asList(str));
        FileInputStream inputStream = null;
        String pdbFile = null;
        File f = null;
        String fpath = this.path + "/" + pdbId;
        for (int i = 0; i < this.extensions.size(); ++i) {
            String ex = (String)this.extensions.get(i);
            f = new File(fpath + ex);
            if (f.exists()) {
                pdbFile = fpath + ex;
                inputStream = new FileInputStream(pdbFile);
                break;
            }
            if (pdbFile != null) break;
        }
        if (pdbFile == null) {
            String message = "no structure with PDB code " + pdbId + " found!";
            throw new IOException(message);
        }
        return inputStream;
    }

    public Structure getStructureById(String pdbId) throws IOException {
        FileInputStream inStream = this.getInputStream(pdbId);
        PDBFileParser pdbpars = new PDBFileParser();
        Structure struc = pdbpars.parsePDBFile(inStream);
        return struc;
    }

    public Structure getStructure(String filename) throws IOException {
        FileInputStream inStream = new FileInputStream(filename);
        PDBFileParser pdbpars = new PDBFileParser();
        Structure struc = pdbpars.parsePDBFile(inStream);
        return struc;
    }
}

