/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game12;

import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game12.GAMEDbxrefHandler;
import org.biojava.bio.seq.io.game12.StAXFeatureHandler;
import org.biojava.bio.seq.io.game12.StAXHandlerFactory;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GAMEGeneHandler
extends StAXFeatureHandler {
    private String release;
    private String name;
    private String association;
    private String synonym;
    public static final StAXHandlerFactory GAME_GENE_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMEGeneHandler(staxenv);
        }
    };

    GAMEGeneHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        super.addHandler(new ElementRecognizer.ByLocalName("name"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new NameHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("dbxref"), GAMEDbxrefHandler.GAME_DBXREF_HANDLER_FACTORY);
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) {
        this.association = attrs.getValue("association");
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) {
    }

    private class NameHandler
    extends StringElementHandlerBase {
        private NameHandler() {
        }

        protected void setStringValue(String s) {
            GAMEGeneHandler.this.name = s.trim();
        }
    }

    private class DbxrefHandler
    extends GAMEDbxrefHandler {
        private DbxrefHandler(StAXFeatureHandler staxenv) {
            super(staxenv);
        }

        public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
            if (this.db_xref_db == null || this.db_xref_id == null) {
                return;
            }
            try {
                this.listener.addFeatureProperty(this.db_xref_db, this.db_xref_id);
            }
            catch (ParseException pe) {
                pe.printStackTrace();
                throw new SAXException("unexpected exception while add <dbxref> as a feature property.");
            }
        }
    }
}

