/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.DataSource;
import org.biojava.bio.program.das.ReferenceServer;
import org.biojava.bio.program.das.TypesFetcher;
import org.biojava.bio.program.das.TypesListener;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ActivityListener;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DAS
extends AbstractChangeable {
    private static List activityListeners;
    private Map dataSources = new HashMap();
    private static boolean threadFetches;
    public static final ChangeType SERVERS;

    public static Set getTypes(URL dasURL) throws BioException {
        final HashSet types = new HashSet();
        try {
            TypesFetcher tf = new TypesFetcher(dasURL, null, null);
            tf.setNullSegmentHandler(new TypesListener(){

                public void startSegment() {
                }

                public void endSegment() {
                }

                public void registerType(String type) {
                    types.add(type);
                }

                public void registerType(String type, int count) {
                    types.add(type);
                }
            });
            tf.runFetch();
        }
        catch (ParseException ex) {
            throw new BioException(ex);
        }
        return Collections.unmodifiableSet(types);
    }

    public static void setThreadFetches(boolean b) {
        threadFetches = b;
    }

    public static boolean getThreadFetches() {
        return threadFetches;
    }

    public static synchronized void addActivityListener(ActivityListener al) {
        activityListeners.add(al);
    }

    public static synchronized void removeActivityListener(ActivityListener al) {
        activityListeners.remove(al);
    }

    public static synchronized void startedActivity(Object source) {
        Iterator i = activityListeners.iterator();
        while (i.hasNext()) {
            ActivityListener al = (ActivityListener)i.next();
            al.startedActivity(source);
        }
    }

    public static synchronized void completedActivity(Object source) {
        Iterator i = activityListeners.iterator();
        while (i.hasNext()) {
            ActivityListener al = (ActivityListener)i.next();
            al.completedActivity(source);
        }
    }

    public static synchronized void activityProgress(Object source, int current, int target) {
        Iterator i = activityListeners.iterator();
        while (i.hasNext()) {
            ActivityListener al = (ActivityListener)i.next();
            al.activityProgress(source, current, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDasURL(URL dasURL) throws BioException, ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SERVERS);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SERVERS);
                cs.firePreChangeEvent(ce);
                this.addDasURLImpl(dasURL);
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.addDasURLImpl(dasURL);
        }
    }

    private void addDasURLImpl(URL dasURL) throws BioException, ChangeVetoException {
        try {
            URL dsnURL = new URL(dasURL, "dsn");
            DAS.startedActivity(this);
            HttpURLConnection huc = (HttpURLConnection)dsnURL.openConnection();
            huc.connect();
            int status2 = DASSequenceDB.tolerantIntHeader(huc, "X-DAS-Status");
            if (status2 == 0) {
                throw new BioException("Not a DAS server: " + dsnURL);
            }
            if (status2 != 200) {
                throw new BioException("DAS error (status code = " + status2 + ")");
            }
            InputSource is = new InputSource(huc.getInputStream());
            is.setSystemId(dsnURL.toString());
            DocumentBuilder parser = DASSequence.nonvalidatingParser();
            NodeList nl = parser.parse(is).getDocumentElement().getElementsByTagName("DSN");
            for (int i = 0; i < nl.getLength(); ++i) {
                DataSource ds;
                Node n = nl.item(i);
                if (!(n instanceof Element)) continue;
                Element dnsE = (Element)n;
                Element source = (Element)dnsE.getElementsByTagName("SOURCE").item(0);
                Element mapmaster = (Element)dnsE.getElementsByTagName("MAPMASTER").item(0);
                Element description = (Element)dnsE.getElementsByTagName("DESCRIPTION").item(0);
                String sourceID = source.getAttribute("id");
                String sourceText = ((Text)source.getFirstChild()).getData().trim();
                String mapURLString = ((Text)mapmaster.getFirstChild()).getData().trim();
                if (mapURLString.charAt(mapURLString.length() - 1) != '/') {
                    mapURLString = mapURLString + '/';
                }
                URL mapURL = new URL(mapURLString);
                String descrText = ((Text)description.getFirstChild()).getData().trim();
                URL dsURL = new URL(dasURL, sourceID + "/");
                ReferenceServer master = (ReferenceServer)this.dataSources.get(mapURL);
                if (dsURL.equals(mapURL)) {
                    if (master != null) {
                        master.setName(sourceText);
                        master.setDescription(descrText);
                        continue;
                    }
                    ds = new ReferenceServer(dsURL, sourceText, descrText);
                    this.dataSources.put(dsURL, ds);
                    continue;
                }
                if (master == null) {
                    master = new ReferenceServer(mapURL, null, null);
                    this.dataSources.put(mapURL, master);
                }
                ds = new DataSource(dsURL, mapURL, sourceText, descrText);
                master.addAnnotator(ds);
            }
        }
        catch (MalformedURLException me) {
            throw new BioException("Can't build DAS url", me);
        }
        catch (IOException ioe) {
            throw new BioException("Can't process URL connection", ioe);
        }
        catch (SAXException se) {
            throw new BioException("Can't parse XML document", se);
        }
        finally {
            DAS.completedActivity(this);
        }
    }

    public Set getReferenceServers() {
        return Collections.unmodifiableSet(new HashSet(this.dataSources.values()));
    }

    static {
        threadFetches = false;
        activityListeners = new ArrayList();
        threadFetches = Boolean.getBoolean("org.biojava.bio.program.das.thread_fetches");
        SERVERS = new ChangeType("Das Servers changed", DAS.class, "SERVERS");
    }
}

