/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.discrete;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.beans.editor.ColorPropertyEditor;
import com.l2fprod.common.beans.editor.FilePropertyEditor;
import com.l2fprod.common.swing.ComponentFactory;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.util.ResourceManager;
import cytoscape.util.CyColorChooser;
import cytoscape.visual.ui.editors.discrete.CyColorCellRenderer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class CyColorPropertyEditor
extends AbstractPropertyEditor {
    private CyColorCellRenderer label;
    private JButton button;
    private Color color;

    public CyColorPropertyEditor() {
        this.editor = new JPanel(new PercentLayout(0, 0));
        this.label = new CyColorCellRenderer();
        ((JPanel)this.editor).add("*", this.label);
        this.label.setOpaque(false);
        this.button = ComponentFactory.Helper.getFactory().createMiniButton();
        ((JPanel)this.editor).add(this.button);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CyColorPropertyEditor.this.selectColor();
            }
        });
        this.button = ComponentFactory.Helper.getFactory().createMiniButton();
        ((JPanel)this.editor).add(this.button);
        this.button.setText("X");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CyColorPropertyEditor.this.selectNull();
            }
        });
        ((JPanel)this.editor).setOpaque(false);
    }

    public Object getValue() {
        return this.color;
    }

    public void setValue(Object value) {
        this.color = (Color)value;
        this.label.setValue(this.color);
    }

    protected void selectColor() {
        ResourceManager rm = ResourceManager.all(FilePropertyEditor.class);
        String title = rm.getString("ColorPropertyEditor.title");
        Color selectedColor = CyColorChooser.showDialog(this.editor, title, this.color);
        if (selectedColor != null) {
            Color oldColor = this.color;
            Color newColor = selectedColor;
            this.label.setValue(newColor);
            this.color = newColor;
            this.firePropertyChange(oldColor, newColor);
        }
    }

    protected void selectNull() {
        Color oldColor = this.color;
        this.label.setValue(null);
        this.color = null;
        this.firePropertyChange(oldColor, null);
    }

    public static class AsInt
    extends ColorPropertyEditor {
        public void setValue(Object arg0) {
            if (arg0 instanceof Integer) {
                super.setValue(new Color((Integer)arg0));
            } else {
                super.setValue(arg0);
            }
        }

        public Object getValue() {
            Object value = super.getValue();
            if (value == null) {
                return null;
            }
            return new Integer(((Color)value).getRGB());
        }

        protected void firePropertyChange(Object oldValue, Object newValue) {
            if (oldValue instanceof Color) {
                oldValue = new Integer(((Color)oldValue).getRGB());
            }
            if (newValue instanceof Color) {
                newValue = new Integer(((Color)newValue).getRGB());
            }
            super.firePropertyChange(oldValue, newValue);
        }
    }
}

